package fr.toutatice.services.calendar.view.portlet.model.events;

import java.awt.Image;
import java.util.Date;
import java.util.List;

import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * Event.
 *
 * @author Julien Barberet
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Primary
public class InteractikEvent extends Event{

    /** Département. */
    private String departement;
    /** Ville */
    private String ville;
    /** URL d'inscription. */
    private String urlInscription;
    /** Date de début d'inscription. */
    private Date debutInscription;
    /** Date de fin d'inscription. */
    private Date finInscription;
    /** Organisateurs. */
    private List<String> organisateurs;
    /** Pôles disciplinaires. */
    private List<String> polesDisciplinaires;
    /** Thèmes. */
    private List<String> themes;
    /** Niveaux. */
    private List<String> niveaux;
    /** Contenus. */
    private List<String> contenus;
    /** Repères DNE. */
    private List<String> reperesDne;
    /**  Visuel de l'événement. */
    private Image visuelEvt;

    public Image getVisuelEvt() {
		return visuelEvt;
	}

	public void setVisuelEvt(Image visuelEvt) {
		this.visuelEvt = visuelEvt;
	}

	/**
     * Constructor.
     *
     * @param id event identifier
     * @param title event title
     * @param startDate event start date
     * @param endDate event end date
     * @param viewURL event view document URL
     */
    public InteractikEvent(String id, String title, Date startDate, Date endDate, boolean allDay, String bckgcolor, String viewURL, String idEventSrc, String idParentSrc) {
        super(id, title, startDate, endDate, allDay, bckgcolor, viewURL, idEventSrc, idParentSrc);
    }

    /**
     * Constructor.
     *
     * @param event event
     */
    public InteractikEvent(Event event) {
        this(event.getId(), event.getTitle(), event.getStartDate(), event.getEndDate(), event.isAllDay(), event.getBckgColor(),
        		event.getViewURL(), event.getIdEventSource(), event.getIdParentSource());
    }


    /**
     * Getter for departement.
     * 
     * @return the departement
     */
    public String getDepartement() {
        return departement;
    }

    /**
     * Setter for departement.
     * 
     * @param departement the departement to set
     */
    public void setDepartement(String departement) {
        this.departement = departement;
    }

    /**
     * Getter for ville.
     * 
     * @return the ville
     */
    public String getVille() {
        return ville;
    }

    /**
     * Setter for ville.
     * 
     * @param ville the ville to set
     */
    public void setVille(String ville) {
        this.ville = ville;
    }

    /**
     * Getter for urlInscription.
     * 
     * @return the urlInscription
     */
    public String getUrlInscription() {
        return urlInscription;
    }

    /**
     * Setter for urlInscription.
     * 
     * @param urlInscription the urlInscription to set
     */
    public void setUrlInscription(String urlInscription) {
        this.urlInscription = urlInscription;
    }

    /**
     * Getter for debutInscription.
     * 
     * @return the debutInscription
     */
    public Date getDebutInscription() {
        return debutInscription;
    }

    /**
     * Setter for debutInscription.
     * 
     * @param debutInscription the debutInscription to set
     */
    public void setDebutInscription(Date debutInscription) {
        this.debutInscription = debutInscription;
    }

    /**
     * Getter for finInscription.
     * 
     * @return the finInscription
     */
    public Date getFinInscription() {
        return finInscription;
    }

    /**
     * Setter for finInscription.
     * 
     * @param finInscription the finInscription to set
     */
    public void setFinInscription(Date finInscription) {
        this.finInscription = finInscription;
    }

    /**
     * Getter for organisateurs.
     * 
     * @return the organisateurs
     */
    public List<String> getOrganisateurs() {
        return organisateurs;
    }

    /**
     * Setter for organisateurs.
     * 
     * @param organisateurs the organisateurs to set
     */
    public void setOrganisateurs(List<String> organisateurs) {
        this.organisateurs = organisateurs;
    }

    /**
     * Getter for polesDisciplinaires.
     * 
     * @return the polesDisciplinaires
     */
    public List<String> getPolesDisciplinaires() {
        return polesDisciplinaires;
    }

    /**
     * Setter for polesDisciplinaires.
     * 
     * @param polesDisciplinaires the polesDisciplinaires to set
     */
    public void setPolesDisciplinaires(List<String> polesDisciplinaires) {
        this.polesDisciplinaires = polesDisciplinaires;
    }

    /**
     * Getter for themes.
     * 
     * @return the themes
     */
    public List<String> getThemes() {
        return themes;
    }

    /**
     * Setter for themes.
     * 
     * @param themes the themes to set
     */
    public void setThemes(List<String> themes) {
        this.themes = themes;
    }

    /**
     * Getter for niveaux.
     * 
     * @return the niveaux
     */
    public List<String> getNiveaux() {
        return niveaux;
    }

    /**
     * Setter for niveaux.
     * 
     * @param niveaux the niveaux to set
     */
    public void setNiveaux(List<String> niveaux) {
        this.niveaux = niveaux;
    }

    /**
     * Getter for contenus.
     * 
     * @return the contenus
     */
    public List<String> getContenus() {
        return contenus;
    }

    /**
     * Setter for contenus.
     * 
     * @param contenus the contenus to set
     */
    public void setContenus(List<String> contenus) {
        this.contenus = contenus;
    }

    /**
     * Getter for reperesDne.
     * 
     * @return the reperesDne
     */
    public List<String> getReperesDne() {
        return reperesDne;
    }

    /**
     * Setter for reperesDne.
     * 
     * @param reperesDne the reperesDne to set
     */
    public void setReperesDne(List<String> reperesDne) {
        this.reperesDne = reperesDne;
    }

}
