/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;
import fr.toutatice.services.calendar.view.portlet.model.Cooperative;
import fr.toutatice.services.calendar.view.portlet.model.InteractikFilters;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikDailyCalendarEventsData;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikDailyEvent;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikEventToSync;
import fr.toutatice.services.calendar.view.portlet.service.InteractikCalendarViewService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import net.fortuna.ical4j.model.component.VEvent;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.view.portlet.model.CalendarOptions;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.service.CalendarViewServiceImpl;
import org.osivia.services.calendar.view.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class InteractikCalendarViewServiceImpl
extends CalendarViewServiceImpl
implements InteractikCalendarViewService {
    private static final String DEPARTEMENT_PROPERTY = "X-DEPARTEMENT";
    private static final String VILLE_PROPERTY = "X-VILLE";
    private static final String DATE_DEBUT_INSCRIPTION_PROPERTY = "X-DATE_DEBUT_INSCRIPTION";
    private static final String DATE_FIN_INSCRIPTION_PROPERTY = "X-DATE_FIN_INSCRIPTION";
    private static final String URLINSCRIPTION_PROPERTY = "X-URLINSCRIPTION";
    private static final String DATE_FORMAT = "yyyyMMdd";
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;

    protected void addIntegrationMenubarItem(PortalControllerContext portalControllerContext) throws PortletException {
        super.addIntegrationMenubarItem(portalControllerContext);
        CalendarOptions options = this.repository.getConfiguration(portalControllerContext);
        if (options.isIntegration()) {
            PortletRequest request = portalControllerContext.getRequest();
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            List menubar = (List)request.getAttribute("osivia.menuBar");
            String path = this.repository.getCalendarPath(portalControllerContext);
            int order = 1;
            for (Cooperative cooperative : Cooperative.values()) {
                String url;
                if (StringUtils.isEmpty((String)path)) {
                    url = null;
                } else {
                    ArrayList<String> filters = new ArrayList<String>();
                    filters.add(StringEscapeUtils.escapeHtml((String)("agenda=" + cooperative.name())));
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("format", "ics");
                    parameters.put("filters", StringUtils.join(filters, (String)"&"));
                    try {
                        url = this.portalUrlFactory.getPermaLink(portalControllerContext, "integration", parameters, path, "resource");
                    }
                    catch (PortalException e) {
                        throw new PortletException((Throwable)e);
                    }
                }
                if (!StringUtils.isNotEmpty(url)) continue;
                String arg = bundle.getString(cooperative.getKey());
                String title = bundle.getString("TIK_CALENDAR_INTEGRATION_ICS_MENUBAR_ITEM", new Object[]{arg});
                MenubarItem item = new MenubarItem("CALENDAR_INTEGRATION_ICS", title, null, (MenubarContainer)MenubarGroup.SPECIFIC, order++, url, null, null, null);
                menubar.add(item);
            }
        }
    }

    public JSONArray loadEventsArray(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        EventsData eventsData = this.getEventsData(portalControllerContext, calendarData);
        List listEvent = ((InteractikDailyCalendarEventsData)eventsData).getEvents();
        Map mapColor = this.getSourcesColor(portalControllerContext);
        JSONArray array = new JSONArray();
        JSONObject object = null;
        Iterator iterator = listEvent.iterator();
        InteractikDailyEvent event = null;
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat formaterAllDay = new SimpleDateFormat("yyyy-MM-dd");
        while (iterator.hasNext()) {
            event = (InteractikDailyEvent)iterator.next();
            object = new JSONObject();
            object.put((Object)"text", (Object)event.getTitle());
            if (event.isAllDay()) {
                object.put((Object)"start_date", (Object)formaterAllDay.format(event.getStartDate()));
                object.put((Object)"end_date", (Object)formaterAllDay.format(event.getEndDate()));
            } else {
                object.put((Object)"start_date", (Object)formater.format(event.getStartDate()));
                object.put((Object)"end_date", (Object)formater.format(event.getEndDate()));
            }
            object.put((Object)"doc_id", (Object)event.getId());
            object.put((Object)"color", (Object)event.getBckgColor());
            object.put((Object)"view_url", (Object)event.getViewURL());
            if (event.getBckgColor() == null) {
                if (event.getIdParentSource() == null) {
                    if (mapColor.get("PRIMARY") != null) {
                        object.put((Object)"extraClass", (Object)((CalendarColor)mapColor.get("PRIMARY")).getBackgroundClass());
                    }
                } else if (mapColor.get(event.getIdParentSource()) == null) {
                    object.put((Object)"extraClass", (Object)InteractikCalendarColor.DEFAULT);
                } else {
                    object.put((Object)"extraClass", (Object)((CalendarColor)mapColor.get(event.getIdParentSource())).getBackgroundClass());
                }
            } else {
                object.put((Object)"extraClass", (Object)InteractikCalendarColor.fromId((String)event.getBckgColor()).getBackgroundClass());
            }
            object.put((Object)"ville", (Object)event.getVille());
            object.put((Object)"readonly", (Object)this.isEventReadOnly(portalControllerContext, (Event)event));
            array.add((Object)object);
        }
        return array;
    }

    public InteractikEventToSync buildEvent(VEvent vevent, String idAgenda, net.fortuna.ical4j.model.TimeZone timeZoneAllEvent) throws PortletException {
        String date;
        Calendar startReccuringStartSource;
        boolean allDay = vevent.getStartDate().getValue().length() == 8 && vevent.getEndDate().getValue().length() == 8;
        Calendar startCal = Calendar.getInstance();
        if (vevent.getStartDate().getTimeZone() != null) {
            startCal.setTimeZone((TimeZone)vevent.getStartDate().getTimeZone());
        } else {
            startCal.setTimeZone((TimeZone)timeZoneAllEvent);
        }
        startCal.setTime((Date)vevent.getStartDate().getDate());
        Calendar endCal = Calendar.getInstance();
        if (vevent.getEndDate().getTimeZone() != null) {
            endCal.setTimeZone((TimeZone)vevent.getEndDate().getTimeZone());
        } else {
            endCal.setTimeZone((TimeZone)timeZoneAllEvent);
        }
        endCal.setTime((Date)vevent.getEndDate().getDate());
        Calendar createdCal = Calendar.getInstance();
        if (vevent.getCreated().getTimeZone() != null) {
            createdCal.setTimeZone((TimeZone)vevent.getCreated().getTimeZone());
        } else {
            createdCal.setTimeZone((TimeZone)timeZoneAllEvent);
        }
        createdCal.setTime((Date)vevent.getCreated().getDate());
        Calendar lastModifiedCal = Calendar.getInstance();
        if (vevent.getLastModified().getTimeZone() != null) {
            lastModifiedCal.setTimeZone((TimeZone)vevent.getLastModified().getTimeZone());
        } else {
            lastModifiedCal.setTimeZone((TimeZone)timeZoneAllEvent);
        }
        lastModifiedCal.setTime((Date)vevent.getLastModified().getDate());
        if (vevent.getRecurrenceId() == null) {
            startReccuringStartSource = null;
        } else {
            startReccuringStartSource = Calendar.getInstance();
            if (vevent.getRecurrenceId().getTimeZone() != null) {
                startReccuringStartSource.setTimeZone((TimeZone)vevent.getRecurrenceId().getTimeZone());
            } else {
                startReccuringStartSource.setTimeZone((TimeZone)timeZoneAllEvent);
            }
            startReccuringStartSource.setTime((Date)vevent.getRecurrenceId().getDate());
        }
        String description = vevent.getDescription() == null ? null : vevent.getDescription().getValue();
        String summary = vevent.getSummary() == null ? null : vevent.getSummary().getValue();
        String uid = vevent.getUid() == null ? null : vevent.getUid().getValue();
        String location = vevent.getLocation() == null ? null : vevent.getLocation().getValue();
        String department = null;
        String urlInscription = null;
        String ville = null;
        Date dateDebutInscription = null;
        Date dateFinInscription = null;
        if (vevent.getProperty(DEPARTEMENT_PROPERTY) != null) {
            department = vevent.getProperty(DEPARTEMENT_PROPERTY).getValue();
        }
        if (vevent.getProperty(URLINSCRIPTION_PROPERTY) != null) {
            urlInscription = vevent.getProperty(URLINSCRIPTION_PROPERTY).getValue();
        }
        if (vevent.getProperty(VILLE_PROPERTY) != null) {
            ville = vevent.getProperty(VILLE_PROPERTY).getValue();
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        if (vevent.getProperty(DATE_DEBUT_INSCRIPTION_PROPERTY) != null) {
            date = vevent.getProperty(DATE_DEBUT_INSCRIPTION_PROPERTY).getValue();
            try {
                dateDebutInscription = format.parse(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (vevent.getProperty(DATE_FIN_INSCRIPTION_PROPERTY) != null) {
            date = vevent.getProperty(DATE_FIN_INSCRIPTION_PROPERTY).getValue();
            try {
                dateFinInscription = format.parse(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return new InteractikEventToSync(null, summary, allDay, startCal, endCal, description, idAgenda, uid, createdCal, lastModifiedCal, startReccuringStartSource, location, department, ville, dateDebutInscription, dateFinInscription, urlInscription);
    }

    private ICalendarGenerator getGenerator(PortalControllerContext portalControllerContext, PeriodTypes periodType) throws PortletException {
        ICalendarGenerator result = null;
        Map generators = this.applicationContext.getBeansOfType(ICalendarGenerator.class);
        for (ICalendarGenerator generator : generators.values()) {
            if (!generator.getPeriodType().getViewPath().equals(periodType.getViewPath())) continue;
            result = generator;
            generator.setPeriodType(periodType);
            break;
        }
        return result;
    }

    public String getEventCreationRedirectionUrl(PortalControllerContext portalControllerContext) throws PortletException {
        String redirectionUrl;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        CalendarOptions options = this.repository.getConfiguration(portalControllerContext);
        String instance = "interactik-calendar-event-edition-instance";
        String path = nuxeoController.getComputedPath(options.getCmsPath());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.cms.uri", path);
        properties.put("theme.dyna.partial_refresh_enabled", String.valueOf(true));
        properties.put("osivia.ajaxLink", "1");
        properties.put("osivia.calendar.creation", String.valueOf(true));
        try {
            redirectionUrl = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, instance, properties);
        }
        catch (PortalException e) {
            throw new PortletException((Throwable)e);
        }
        return redirectionUrl;
    }

    public InteractikFilters getFilters(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        InteractikFilters filters = (InteractikFilters)this.applicationContext.getBean(InteractikFilters.class);
        filters.setCooperative22(BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)request.getParameter("cooperative22")), (boolean)true));
        filters.setCooperative29(BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)request.getParameter("cooperative29")), (boolean)true));
        filters.setCooperative35(BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)request.getParameter("cooperative35")), (boolean)true));
        filters.setCooperative56(BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)request.getParameter("cooperative56")), (boolean)true));
        filters.setCooperativeAcademie(BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)request.getParameter("cooperativeAcademie")), (boolean)true));
        return filters;
    }
}

