package fr.toutatice.services.calendar.view.portlet.model.calendar;

import java.util.List;

import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import fr.toutatice.services.calendar.view.portlet.model.Cooperative;
import fr.toutatice.services.calendar.view.portlet.model.InteractikFilters;


/**
 * Calendar data.
 * 
 * @author Julien Barberet
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Primary
public class InteractikCalendarData extends CalendarData{

    /** Display cooperatives indicator. */
    private boolean displayCooperatives;
    
    private InteractikFilters filters;

    public InteractikFilters getFilters() {
		return filters;
	}

	public void setFilters(InteractikFilters filters) {
		this.filters = filters;
	}

	/** Coopératives. */
    private List<Cooperative> cooperatives;

    /**
     * Default constructor.
     */
    public InteractikCalendarData() {
        super();    
    }
    
    /**
     * Getter for displayCooperatives.
     * 
     * @return the displayCooperatives
     */
    public boolean isDisplayCooperatives() {
        return displayCooperatives;
    }

    /**
     * Setter for displayCooperatives.
     * 
     * @param displayCooperatives the displayCooperatives to set
     */
    public void setDisplayCooperatives(boolean displayCooperatives) {
        this.displayCooperatives = displayCooperatives;
    }

    /**
     * Getter for cooperatives.
     * 
     * @return the cooperatives
     */
    public List<Cooperative> getCooperatives() {
        return cooperatives;
    }

    /**
     * Setter for cooperatives.
     * 
     * @param cooperatives the cooperatives to set
     */
    public void setCooperatives(List<Cooperative> cooperatives) {
        this.cooperatives = cooperatives;
    }
}
