package fr.toutatice.services.calendar.view.portlet.service.generator;

import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.AGENDA_INTERACTIK;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_22;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_29;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_35;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_56;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_ACADEMIE;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.portlet.PortletException;
import javax.portlet.PortletRequest;

import fr.toutatice.services.calendar.view.portlet.model.InteractikFilters;
import org.apache.commons.beanutils.PropertyUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.view.portlet.model.CalendarOptions;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.view.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;

import fr.toutatice.services.calendar.view.portlet.model.Cooperative;
import fr.toutatice.services.calendar.view.portlet.model.InteractikCalendarOptions;
import fr.toutatice.services.calendar.view.portlet.model.calendar.InteractikCalendarData;
import org.springframework.context.ApplicationContext;


/**
 * Calendar generator implementation super-class.
 *
 * @author Julien Barberet
 * @see ICalendarGenerator
 */
public abstract class InteractikCalendarGeneratorImpl extends CalendarGeneratorImpl implements ICalendarGenerator {

    /** Application context. */
    @Autowired
    private ApplicationContext applicationContext;

    /** Calendar repository. */
    @Autowired
    private CalendarViewRepository calendarRepository;

	/**
     * Constructor.
     */
    public InteractikCalendarGeneratorImpl() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public CalendarData generateCalendarData(PortalControllerContext portalControllerContext, PeriodTypes periodType) throws PortletException {
        // Calendar data
        CalendarData calendarData = super.generateCalendarData(portalControllerContext, periodType);
        // Options
        CalendarOptions options = this.calendarRepository.getConfiguration(portalControllerContext);
        if ((calendarData instanceof InteractikCalendarData) && (options instanceof InteractikCalendarOptions)) {
            InteractikCalendarData interactikCalendarData = (InteractikCalendarData) calendarData;
            InteractikCalendarOptions interactikOptions = (InteractikCalendarOptions) options;

            // Coopératives
            Cooperative selectedCooperative = interactikOptions.getSelectedCooperative();
            if ((selectedCooperative == null) || !selectedCooperative.isDisplayed()) {
                // By default, all cooperatives are set to true
                interactikCalendarData.setDisplayCooperatives(true);
            } else {
                InteractikFilters filters = interactikCalendarData.getFilters();
                if (filters == null) {
                    filters = this.applicationContext.getBean(InteractikFilters.class);
                    interactikCalendarData.setFilters(filters);
                }
                try {
                    PropertyUtils.setSimpleProperty(filters, selectedCooperative.getProperty(), true);
                } catch (IllegalAccessException | InvocationTargetException | NoSuchMethodException e) {
                    throw new PortletException(e);
                }
                interactikCalendarData.setDisplayCooperatives(false);
            }
            interactikCalendarData.setCooperatives(new ArrayList<>(Arrays.asList(Cooperative.values())));
        }

        return calendarData;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EventsData generateEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        request.setAttribute(COOPERATIVE_22, request.getParameter(COOPERATIVE_22));
        request.setAttribute(COOPERATIVE_29, request.getParameter(COOPERATIVE_29));
        request.setAttribute(COOPERATIVE_35, request.getParameter(COOPERATIVE_35));
        request.setAttribute(COOPERATIVE_56, request.getParameter(COOPERATIVE_56));
        request.setAttribute(COOPERATIVE_ACADEMIE, request.getParameter(COOPERATIVE_ACADEMIE));
        request.setAttribute(AGENDA_INTERACTIK, true);

        // Events
        List<Event> events = this.calendarRepository.getEvents(portalControllerContext, calendarData.getStartDate(), calendarData.getEndDate());

        // Events data
        EventsData eventsData;
        if (events == null) {
            eventsData = null;
        } else {
            eventsData = this.generateSpecializedEventsData(portalControllerContext, calendarData, events);
        }

        return eventsData;
    }

}
