/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;
import fr.toutatice.services.calendar.view.portlet.model.Cooperative;
import fr.toutatice.services.calendar.view.portlet.model.InteractikCalendarOptions;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikEvent;
import fr.toutatice.services.calendar.view.portlet.repository.command.InteractikEventEditionCommand;
import fr.toutatice.services.calendar.view.portlet.repository.command.InteractikEventListCommand;
import fr.toutatice.services.calendar.view.portlet.repository.command.InteractikSynchronizationCommand;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.calendar.view.portlet.model.CalendarEditionMode;
import org.osivia.services.calendar.view.portlet.model.CalendarOptions;
import org.osivia.services.calendar.view.portlet.model.CalendarViewForm;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventKey;
import org.osivia.services.calendar.view.portlet.model.events.EventToSync;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepositoryImpl;
import org.osivia.services.calendar.view.portlet.repository.command.EventGetCommand;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

@Repository
@Primary
public class InteractikCalendarViewRepositoryImpl
extends CalendarViewRepositoryImpl {
    private static final String COOPERATIVE_WINDOW_PROPERTY = "interactik.calendar.cooperative";

    public CalendarOptions getConfiguration(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarOptions options = super.getConfiguration(portalControllerContext);
        if (options instanceof InteractikCalendarOptions) {
            InteractikCalendarOptions customizedOptions = (InteractikCalendarOptions)options;
            PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
            Cooperative selectedCooperative = Cooperative.fromName((String)window.getProperty(COOPERATIVE_WINDOW_PROPERTY));
            customizedOptions.setSelectedCooperative(selectedCooperative);
        }
        return options;
    }

    public void saveConfiguration(PortalControllerContext portalControllerContext, CalendarOptions options) throws PortletException {
        super.saveConfiguration(portalControllerContext, options);
        if (options instanceof InteractikCalendarOptions) {
            InteractikCalendarOptions customizedOptions = (InteractikCalendarOptions)options;
            PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
            Cooperative selectedCooperative = customizedOptions.getSelectedCooperative();
            if (selectedCooperative == null || !selectedCooperative.isDisplayed()) {
                window.setProperty(COOPERATIVE_WINDOW_PROPERTY, null);
            } else {
                window.setProperty(COOPERATIVE_WINDOW_PROPERTY, selectedCooperative.name());
            }
        }
    }

    public Event getEvent(PortalControllerContext portalControllerContext, String docid) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
        String cmsPath = this.getCMSPath(nuxeoController);
        EventGetCommand nuxeoCommand = new EventGetCommand(cmsPath, docid);
        Document document = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
        return this.fillEvent(document, nuxeoController);
    }

    public void synchronize(PortalControllerContext portalControllerContext, Map<EventKey, EventToSync> map) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String cmsPath = this.getCMSPath(nuxeoController);
        String parentPath = nuxeoController.getContentPath();
        InteractikSynchronizationCommand nuxeoCommand = new InteractikSynchronizationCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, cmsPath, parentPath, map);
        nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
    }

    public void save(PortalControllerContext portalControllerContext, CalendarViewForm form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        String cmsPath = this.getCMSPath(nuxeoController);
        form.setParentPath(cmsPath);
        INuxeoCommand command = (INuxeoCommand)this.applicationContext.getBean(InteractikEventEditionCommand.class, new Object[]{form});
        Document document = (Document)nuxeoController.executeNuxeoCommand(command);
        if (CalendarEditionMode.EDITION.equals((Object)form.getMode())) {
            NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(document.getPath());
            documentContext.reload();
            document = documentContext.getDocument();
        }
        form.setDocument((DocRef)document);
    }

    public List<Event> getEvents(PortalControllerContext portalControllerContext, Date start, Date end) throws PortletException {
        ArrayList<Event> events;
        boolean cooperativeAcademie;
        boolean cooperative56;
        boolean cooperative35;
        boolean cooperative29;
        boolean cooperative22;
        boolean agendaInteractik;
        NuxeoController nuxeoController;
        block17: {
            PortletRequest request;
            block16: {
                String[] selectedCooperative;
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    nuxeoController = new NuxeoController(portalControllerContext.getRequest(), portalControllerContext.getResponse(), portalControllerContext.getPortletCtx());
                                    request = portalControllerContext.getRequest();
                                    agendaInteractik = false;
                                    if (request.getAttribute("AgendaInteractik") != null) {
                                        agendaInteractik = BooleanUtils.toBoolean((Boolean)((Boolean)request.getAttribute("AgendaInteractik")));
                                        request.removeAttribute("AgendaInteractik");
                                    }
                                    cooperative22 = false;
                                    cooperative29 = false;
                                    cooperative35 = false;
                                    cooperative56 = false;
                                    cooperativeAcademie = false;
                                    if (!StringUtils.isEmpty((String)request.getParameter("format"))) break block16;
                                    CalendarOptions options = this.getConfiguration(portalControllerContext);
                                    if (!(options instanceof InteractikCalendarOptions)) break block17;
                                    InteractikCalendarOptions interactikOptions = (InteractikCalendarOptions)options;
                                    selectedCooperative = interactikOptions.getSelectedCooperative();
                                    if (selectedCooperative != null && selectedCooperative.isDisplayed()) break block18;
                                    if (request.getAttribute("cooperative22") != null) {
                                        cooperative22 = BooleanUtils.toBoolean((String)request.getParameter("cooperative22"));
                                        request.removeAttribute("cooperative22");
                                    }
                                    if (request.getAttribute("cooperative29") != null) {
                                        cooperative29 = BooleanUtils.toBoolean((String)request.getParameter("cooperative29"));
                                        request.removeAttribute("cooperative29");
                                    }
                                    if (request.getAttribute("cooperative35") != null) {
                                        cooperative35 = BooleanUtils.toBoolean((String)request.getParameter("cooperative35"));
                                        request.removeAttribute("cooperative35");
                                    }
                                    if (request.getAttribute("cooperative56") != null) {
                                        cooperative56 = BooleanUtils.toBoolean((String)request.getParameter("cooperative56"));
                                        request.removeAttribute("cooperative56");
                                    }
                                    if (request.getAttribute("cooperativeAcademie") != null) {
                                        cooperativeAcademie = BooleanUtils.toBoolean((String)request.getParameter("cooperativeAcademie"));
                                        request.removeAttribute("cooperativeAcademie");
                                    }
                                    break block17;
                                }
                                if (!Cooperative.COTES_ARMOR.equals((Object)selectedCooperative)) break block19;
                                cooperative22 = true;
                                break block17;
                            }
                            if (!Cooperative.FINISTERE.equals((Object)selectedCooperative)) break block20;
                            cooperative29 = true;
                            break block17;
                        }
                        if (!Cooperative.ILLE_ET_VILAINE.equals((Object)selectedCooperative)) break block21;
                        cooperative35 = true;
                        break block17;
                    }
                    if (!Cooperative.MORBIHAN.equals((Object)selectedCooperative)) break block22;
                    cooperative56 = true;
                    break block17;
                }
                if (!Cooperative.ACADEMIE.equals((Object)selectedCooperative)) break block17;
                cooperativeAcademie = true;
                break block17;
            }
            agendaInteractik = true;
            String filtersParameter = request.getParameter("filters");
            if (StringUtils.isEmpty((String)filtersParameter)) {
                cooperative22 = true;
                cooperative29 = true;
                cooperative35 = true;
                cooperative56 = true;
                cooperativeAcademie = true;
            } else {
                String[] filters;
                for (String filter : filters = StringUtils.split((String)filtersParameter, (String)"&")) {
                    Object[] entry = StringUtils.split((String)filter, (String)"=");
                    if (!ArrayUtils.isNotEmpty((Object[])entry) || entry.length != 2) continue;
                    Object name = entry[0];
                    Object value = entry[1];
                    if (!StringUtils.equals((String)"agenda", (String)name)) continue;
                    Cooperative cooperative = Cooperative.fromName((String)value);
                    if (Cooperative.COTES_ARMOR.equals((Object)cooperative)) {
                        cooperative22 = true;
                        continue;
                    }
                    if (Cooperative.FINISTERE.equals((Object)cooperative)) {
                        cooperative29 = true;
                        continue;
                    }
                    if (Cooperative.ILLE_ET_VILAINE.equals((Object)cooperative)) {
                        cooperative35 = true;
                        continue;
                    }
                    if (Cooperative.MORBIHAN.equals((Object)cooperative)) {
                        cooperative56 = true;
                        continue;
                    }
                    if (!Cooperative.ACADEMIE.equals((Object)cooperative)) continue;
                    cooperativeAcademie = true;
                }
            }
        }
        String cmsPath = this.getCMSPath(nuxeoController);
        if (StringUtils.isEmpty((String)cmsPath)) {
            events = null;
        } else {
            List listSource = this.getSynchronizationSources(portalControllerContext);
            InteractikEventListCommand nuxeoCommand = new InteractikEventListCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, cmsPath, start, end, listSource, cooperative22, cooperative29, cooperative35, cooperative56, cooperativeAcademie, agendaInteractik);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
            events = new ArrayList<Event>(documents.size());
            for (Document document : documents) {
                if (document.getDate("vevent:dtstart") == null || document.getDate("vevent:dtend") == null) continue;
                Event event = this.fillEvent(document, nuxeoController);
                events.add(event);
            }
        }
        return events;
    }

    protected Event fillEvent(Document document, NuxeoController nuxeoController) {
        Date date;
        SimpleDateFormat fmt;
        String dateJour;
        Event event = super.fillEvent(document, nuxeoController);
        String bckgcolor = document.getString("vevent:color");
        String dept = document.getString("ttctik:departement");
        if (dept != null) {
            if ("aca".equals(dept)) {
                bckgcolor = InteractikCalendarColor.ACADEMIE_BRETAGNE.toString();
            } else if ("22".equals(dept)) {
                bckgcolor = InteractikCalendarColor.COTE_D_ARMOR.toString();
            } else if ("29".equals(dept)) {
                bckgcolor = InteractikCalendarColor.FINISTERE.toString();
            } else if ("35".equals(dept)) {
                bckgcolor = InteractikCalendarColor.ILE_ET_VILAINE.toString();
            } else if ("56".equals(dept)) {
                bckgcolor = InteractikCalendarColor.MORBIHAN.toString();
            }
        }
        if ((dateJour = (fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss")).format(date = new Date())).compareTo(document.getString("vevent:dtend").substring(0, 19)) > 0) {
            bckgcolor = InteractikCalendarColor.GREY.toString();
        }
        event.setBckgColor(bckgcolor);
        if (event instanceof InteractikEvent) {
            InteractikEvent interactikEvent = (InteractikEvent)event;
            String departement = document.getString("ttctik:departement");
            interactikEvent.setDepartement(departement);
            String ville = document.getString("ttctik:ville");
            interactikEvent.setVille(ville);
            String urlInscription = document.getString("ttctik:urlInscription");
            interactikEvent.setUrlInscription(urlInscription);
            Date debutInscription = document.getDate("ttctik:datedebutinscription");
            interactikEvent.setDebutInscription(debutInscription);
            Date finInscription = document.getDate("ttctik:datefininscription");
            interactikEvent.setFinInscription(finInscription);
            List organisateurs = this.getEventProperties(document, "ttctik:organisateurs");
            interactikEvent.setOrganisateurs(organisateurs);
            List polesDisciplinaires = this.getEventProperties(document, "ttctik:polesDisciplinaires");
            interactikEvent.setPolesDisciplinaires(polesDisciplinaires);
            List themes = this.getEventProperties(document, "ttctik:themes");
            interactikEvent.setThemes(themes);
            List niveaux = this.getEventProperties(document, "ttctik:niveaux");
            interactikEvent.setNiveaux(niveaux);
            List contenus = this.getEventProperties(document, "ttctik:contenus");
            interactikEvent.setContenus(contenus);
            List reperesDne = this.getEventProperties(document, "ttctik:reperesDne");
            interactikEvent.setReperesDne(reperesDne);
        }
        return event;
    }

    private List<String> getEventProperties(Document document, String propertyName) {
        ArrayList<String> properties;
        PropertyList list = document.getProperties().getList(propertyName);
        if (list == null || list.isEmpty()) {
            properties = null;
        } else {
            properties = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                String value = list.getString(i);
                properties.add(value);
            }
        }
        return properties;
    }
}

