<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://www.osivia.org/jsp/taglib/osivia-portal" prefix="op" %>
<%@ taglib uri="http://www.toutatice.fr/jsp/taglib/toutatice" prefix="ttc" %>

<%@ page contentType="text/html" isELIgnored="false"%>


<div class="interactik-calendar-event-view">
    <!-- Date -->
    <div class="schedule" id="date">
    	<div>
        	<strong>${form.formattedDate}</strong>
        	<c:if test="${not empty form.formattedTime}">
            	<span>-</span>
            	<span>${form.formattedTime}</span>
        	</c:if>
        </div>
    </div>
    
    <div class="infos">
        <div class="infos-header">
            <!-- Title -->
            <h3 class="text-uppercase" id="header-1">
                <strong>${form.document.properties['dc:title']}</strong>
            </h3>
            
            <!-- Location -->
            <p class="text-pre-wrap" id="header-2">${form.document.properties['vevent:location']}</p>
        </div>
    
        <div class="row">
            <div class="col-sm-8">
                <!-- Actions -->
                <%@ include file="actions.jspf" %>
                
                <dl class="dl-horizontal" id="infos">
                    <!-- Organisateurs -->
                    <%@ include file="organisateurs.jspf" %>
                    <!-- Ples disciplinaires -->
                    <%@ include file="poles-disciplinaires.jspf"%>
                    <!-- Niveaux -->
                    <%@ include file="niveaux.jspf"%>
                    <!-- Thmes -->
                    <%@ include file="themes.jspf"%>
                    <!-- Contenus -->
                    <%@ include file="contenus.jspf"%>
                </dl>
            </div>
            
            <div class="col-sm-4">
                <!-- Picture -->
                <%@ include file="picture.jspf"%>
            </div>
        </div>
        
        <div class="content" id="contenu"><ttc:transform document="${form.document}" property="note:note" /></div>
    </div>
</div>


<div class="interactik-calendar-event-view-back">
    <a href="javascript:window.history.back()" class="no-ajax-link">
        <i class="glyphicons glyphicons-chevron-left"></i>
        <span><op:translate key="TIK_CALENDAR_EVENT_BACK"/></span>
    </a>
</div>
