package fr.toutatice.services.calendar.event.edition.portlet.configuration;

import org.apache.commons.lang.CharEncoding;
import org.osivia.services.calendar.event.edition.portlet.configuration.CalendarEventEditionConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.portlet.multipart.CommonsPortletMultipartResolver;
import org.springframework.web.portlet.multipart.PortletMultipartResolver;

/**
 * Calendar event edition portlet configuration.
 *
 * @author Julien Barberet
 */
@Configuration
@ComponentScan(basePackages = {"fr.toutatice.services.calendar.event.edition.portlet", "fr.toutatice.services.calendar.common"})
public class InteractikCalendarEventEditionConfiguration extends CalendarEventEditionConfiguration {

    /**
     * Constructor.
     */
    public InteractikCalendarEventEditionConfiguration() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Bean(name = "messageSource")
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames("interactik", "calendar-event-edition", "calendar-common");
        return messageSource;
    }
    /**
     * Get multipart resolver.
     * 
     * @return multipart resolver
     */
    @Bean(name = "portletMultipartResolver")
    public PortletMultipartResolver getMultipartResolver() {
        CommonsPortletMultipartResolver multipartResolver = new CommonsPortletMultipartResolver();
        multipartResolver.setDefaultEncoding(CharEncoding.UTF_8);
        return multipartResolver;
    }
}
