package fr.toutatice.services.calendar.integration.portlet.configuration;

import org.osivia.services.calendar.integration.portlet.configuration.CalendarIntegrationConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;

/**
 * Interactik calendar integration portlet configuration.
 *
 * @author Cédric Krommenhoek
 * @see CalendarIntegrationConfiguration
 */
@Configuration
@ComponentScan(basePackages = "fr.toutatice.services.calendar.integration.portlet")
public class InteractikCalendarIntegrationConfiguration extends CalendarIntegrationConfiguration {

    /**
     * Constructor.
     */
    public InteractikCalendarIntegrationConfiguration() {
        super();
    }


    /**
     * Get message source.
     *
     * @return message source
     */
    @Bean(name = "messageSource")
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames("calendar-integration", "interactik");
        return messageSource;
    }

}
