package fr.toutatice.services.calendar.integration.portlet.model;

import fr.toutatice.services.calendar.view.portlet.model.Cooperative;
import org.osivia.services.calendar.integration.portlet.model.CalendarIntegrationForm;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@Primary
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class InteractikCalendarIntegrationForm extends CalendarIntegrationForm {

    /**
     * Cooperatives integration URLs.
     */
    private Map<Cooperative, String> cooperatives;


    /**
     * Constructor.
     */
    public InteractikCalendarIntegrationForm() {
        super();
    }


    public Map<Cooperative, String> getCooperatives() {
        return cooperatives;
    }

    public void setCooperatives(Map<Cooperative, String> cooperatives) {
        this.cooperatives = cooperatives;
    }
}
