package fr.toutatice.services.calendar.integration.portlet.service;

import fr.toutatice.services.calendar.integration.portlet.model.InteractikCalendarIntegrationForm;
import fr.toutatice.services.calendar.view.portlet.model.Cooperative;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.calendar.integration.portlet.model.CalendarIntegrationForm;
import org.osivia.services.calendar.integration.portlet.service.CalendarIntegrationServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import java.util.*;

/**
 * Interactik calendar integration portlet service implementation.
 *
 * @author Cédric Krommenhoek
 * @see CalendarIntegrationServiceImpl
 * @see InteractikCalendarIntegrationService
 */
@Service
@Primary
public class InteractikCalendarIntegrationServiceImpl extends CalendarIntegrationServiceImpl implements InteractikCalendarIntegrationService {

    /**
     * Portal URL factory.
     */
    @Autowired
    private IPortalUrlFactory portalUrlFactory;

    /**
     * Internationalization bundle factory.
     */
    @Autowired
    private IBundleFactory bundleFactory;


    /**
     * Constructor.
     */
    public InteractikCalendarIntegrationServiceImpl() {
        super();
    }


    @Override
    public CalendarIntegrationForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        // Portlet request
        PortletRequest request = portalControllerContext.getRequest();
        // Window
        PortalWindow window = WindowFactory.getWindow(request);
        // Internationalization bundle
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());

        // Calendar path
        String path = this.getCalendarPath(portalControllerContext);
        // Selected cooperative
        Cooperative selectedCooperative = Cooperative.fromName(window.getProperty(SELECTED_COOPERATIVE_WINDOW_PROPERTY));

        // Form
        CalendarIntegrationForm form = super.getForm(portalControllerContext);

        if (form instanceof InteractikCalendarIntegrationForm) {
            // Interactik form
            InteractikCalendarIntegrationForm interactikForm = (InteractikCalendarIntegrationForm) form;

            // Cooperatives integration URLs
            Map<Cooperative, String> cooperatives = new LinkedHashMap<>();
            for (Cooperative cooperative : Cooperative.values()) {
                if ((selectedCooperative == null) || Cooperative.ACADEMIE.equals(cooperative) || selectedCooperative.equals(cooperative)) {
                    // Filters
                    List<String> filters = new ArrayList<>();
                    filters.add(StringEscapeUtils.escapeHtml("agenda=" + cooperative.name()));

                    // Parameters
                    Map<String, String> parameters = new HashMap<>();
                    parameters.put("format", "ics");
                    parameters.put("filters", StringUtils.join(filters, "&"));

                    // URL
                    String url;
                    try {
                        url = this.portalUrlFactory.getPermaLink(portalControllerContext, "integration", parameters, path,
                                IPortalUrlFactory.PERM_LINK_TYPE_PORTLET_RESOURCE);
                    } catch (PortalException e) {
                        throw new PortletException(e);
                    }
                    url = StringUtils.replace(url, "/commands?", "/commands/events.ics?");
                    cooperatives.put(cooperative, url);
                }
            }
            interactikForm.setCooperatives(cooperatives);
        }

        return form;
    }

}
