package fr.toutatice.services.calendar.view.portlet.model;

import org.apache.commons.lang.StringUtils;

/**
 * Coopératives enumeration.
 * 
 * @author Cédric Krommenhoek
 */
public enum Cooperative {

    /** Côtes-d'Armor. */
    COTES_ARMOR("TIK_COOPERATIVE_22", "cooperative22", true),
    /** Finistère. */
    FINISTERE("TIK_COOPERATIVE_29", "cooperative29", true),
    /** Ille-et-Vilaine. */
    ILLE_ET_VILAINE("TIK_COOPERATIVE_35", "cooperative35", true),
    /** Morbihan. */
    MORBIHAN("TIK_COOPERATIVE_56", "cooperative56", true),
    /** Académie. */
    ACADEMIE("TIK_COOPERATIVE_ACADEMIE", "cooperativeAcademie", false);


    /** Internationalization key. */
    private final String key;
    /** Property name. */
    private final String property;
    /** Displayed indicator. */
    private final boolean displayed;

    
    /**
     * Constructor.
     * 
     * @param key internationalization key
     * @param property property name
     * @param displayed displayed indicator
     */
    private Cooperative(String key, String property, boolean displayed) {
        this.key = key;
        this.property = property;
        this.displayed = displayed;
    }
    

    /**
     * Get cooperative from name.
     * 
     * @param name cooperative name
     * @return cooperative, may be null if not found
     */
    public static Cooperative fromName(String name) {
        Cooperative result = null;

        Cooperative[] values = Cooperative.values();
        for (int i = 0; i < values.length; i++) {
            Cooperative value = values[i];
            
            if (StringUtils.equalsIgnoreCase(name, value.name())) {
                result = value;
                break;
            }
        }

        return result;
    }


    /**
     * Getter for key.
     * 
     * @return the key
     */
    public String getKey() {
        return key;
    }

    /**
     * Getter for property.
     * 
     * @return the property
     */
    public String getProperty() {
        return property;
    }

    /**
     * Getter for displayed.
     * 
     * @return the displayed
     */
    public boolean isDisplayed() {
        return displayed;
    }

}
