/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.batch;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.services.calendar.batch.command.InteractikSynchronizationCommand;
import fr.toutatice.services.calendar.batch.command.ListInteractikAgendaCommand;
import fr.toutatice.services.calendar.view.portlet.model.events.InteractikEventToSync;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.batch.AbstractBatch;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.services.calendar.edition.portlet.model.CalendarSynchronizationSource;
import org.osivia.services.calendar.view.portlet.model.events.EventKey;
import org.osivia.services.calendar.view.portlet.model.events.EventToSync;

public class SynchronizationEvrigoBatch
extends AbstractBatch {
    public static final String DEPARTEMENT_PROPERTY = "X-DEPARTEMENT";
    public static final String VILLE_PROPERTY = "X-VILLE";
    public static final String DATE_DEBUT_INSCRIPTION_PROPERTY = "X-DATE_DEBUT_INSCRIPTION";
    public static final String DATE_FIN_INSCRIPTION_PROPERTY = "X-DATE_FIN_INSCRIPTION";
    public static final String URLINSCRIPTION_PROPERTY = "X-URLINSCRIPTION";
    public static final String ORGANISATEURS_PROPERTY = "X-ORGANISATEUR_INTERACTIK";
    public static final String POLES_DISCIPLINAIRES_PROPERTY = "X-POLE_INTERACTIK";
    public static final String THEMES_PROPERTY = "X-THEME_INTERACTIK";
    public static final String NIVEAUX_PROPERTY = "X-NIVEAU_INTERACTIK";
    public static final String CONTENUS_PROPERTY = "X-CONTENU_INTERACTIK";
    public static final String REPERES_DNE_PROPERTY = "X-REPERE_DNE_INTERACTIK";
    protected static final Log logger = LogFactory.getLog(SynchronizationEvrigoBatch.class);
    private static final String LIST_SOURCE_SYNCHRO = "cal:sources";
    private static final String URL_SYNCHRONIZATION = "url";
    private static final String SOURCEID_SYNCHRONIZATION = "sourceId";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private static final String CRON_DEFAULT_VALUE = "0 0/2 * * * ?";
    private static PortletContext portletContext;

    public boolean isRunningOnMasterOnly() {
        return true;
    }

    public String getJobScheduling() {
        return System.getProperty("CRON_BATCH_EVRIGO", CRON_DEFAULT_VALUE);
    }

    public void execute(Map<String, Object> parameters) {
        logger.info((Object)"Ex\u00e9cution du batch import Evrigo");
        NuxeoController nuxeoController = new NuxeoController(portletContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        ListInteractikAgendaCommand nuxeoCommand = new ListInteractikAgendaCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED);
        Documents agendasInteractik = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
        for (Document agenda : agendasInteractik) {
            PropertyList propertyList = (PropertyList)agenda.getProperties().get(LIST_SOURCE_SYNCHRO);
            if (propertyList == null) continue;
            for (int i = 0; i < propertyList.size(); ++i) {
                PropertyMap map = propertyList.getMap(i);
                CalendarSynchronizationSource source = new CalendarSynchronizationSource();
                source.setUrl(map.getString(URL_SYNCHRONIZATION));
                source.setId(map.getString(SOURCEID_SYNCHRONIZATION));
                try {
                    Map mapEvents = this.getEventsFromUrl(new URL(source.getUrl()), source.getId());
                    nuxeoCommand = new InteractikSynchronizationCommand(NuxeoQueryFilterContext.CONTEXT_LIVE_N_PUBLISHED, agenda.getPath(), mapEvents);
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
                    continue;
                }
                catch (MalformedURLException e) {
                    logger.error((Object)("Impossible d'acc\u00e9der \u00e0 l'URL de synchronisation, d\u00e9tail:" + e.getMessage()));
                }
            }
        }
    }

    public void setPortletContext(PortletContext portletContext) {
        SynchronizationEvrigoBatch.portletContext = portletContext;
    }

    private Map<EventKey, EventToSync> getEventsFromUrl(URL url, String idSource) {
        HashMap<EventKey, EventToSync> mapEvents = new HashMap<EventKey, EventToSync>();
        try {
            URLConnection connection = url.openConnection();
            CalendarBuilder calendarBuilder = new CalendarBuilder();
            Calendar calendar = calendarBuilder.build(connection.getInputStream());
            ComponentList listComponent = calendar.getComponents();
            ComponentList listEvent = listComponent.getComponents("VEVENT");
            VTimeZone vTimeZoneAllEvent = (VTimeZone)calendar.getComponent("VTIMEZONE");
            TimeZone timeZoneAllEvent = null;
            if (vTimeZoneAllEvent == null) {
                TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
                timeZoneAllEvent = registry.getTimeZone("GMT");
            } else {
                timeZoneAllEvent = new TimeZone(vTimeZoneAllEvent);
            }
            for (VEvent event : listEvent) {
                java.util.Calendar cal;
                if (event.getRecurrenceId() == null) {
                    cal = null;
                } else {
                    cal = java.util.Calendar.getInstance();
                    if (event.getRecurrenceId().getTimeZone() == null) {
                        cal.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
                    } else {
                        cal.setTimeZone((java.util.TimeZone)event.getRecurrenceId().getTimeZone());
                    }
                    cal.setTime((Date)event.getRecurrenceId().getDate());
                }
                EventKey key = new EventKey(event.getUid().getValue(), idSource, cal);
                mapEvents.put(key, (EventToSync)this.buildEvent(event, idSource, timeZoneAllEvent, url.toString()));
            }
        }
        catch (ParserException e) {
            logger.error((Object)("Erreur de parsing lors de la synchronisation, d\u00e9tail:" + e.getMessage()));
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Impossible d'acc\u00e9der \u00e0 l'URL de synchronisation, d\u00e9tail:" + e.getMessage()));
        }
        catch (IOException e) {
            logger.error((Object)("Erreur de parsing lors de la synchronisation, d\u00e9tail:" + e.getMessage()));
        }
        logger.warn((Object)(mapEvents.size() + " \u00e9v\u00e9nements pars\u00e9s avec succ\u00e8s"));
        return mapEvents;
    }

    private InteractikEventToSync buildEvent(VEvent vevent, String idAgenda, TimeZone timeZoneAllEvent, String url) {
        java.util.Calendar startReccuringStartSource;
        boolean allDay = vevent.getStartDate().getValue().length() == 8 && vevent.getEndDate().getValue().length() == 8;
        java.util.Calendar startCal = java.util.Calendar.getInstance();
        if (vevent.getStartDate().getTimeZone() != null) {
            startCal.setTimeZone((java.util.TimeZone)vevent.getStartDate().getTimeZone());
        } else {
            startCal.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
        }
        startCal.setTime((Date)vevent.getStartDate().getDate());
        java.util.Calendar endCal = java.util.Calendar.getInstance();
        if (vevent.getEndDate().getTimeZone() != null) {
            endCal.setTimeZone((java.util.TimeZone)vevent.getEndDate().getTimeZone());
        } else {
            endCal.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
        }
        endCal.setTime((Date)vevent.getEndDate().getDate());
        java.util.Calendar createdCal = java.util.Calendar.getInstance();
        if (vevent.getCreated().getTimeZone() != null) {
            createdCal.setTimeZone((java.util.TimeZone)vevent.getCreated().getTimeZone());
        } else {
            createdCal.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
        }
        createdCal.setTime((Date)vevent.getCreated().getDate());
        java.util.Calendar lastModifiedCal = java.util.Calendar.getInstance();
        if (vevent.getLastModified().getTimeZone() != null) {
            lastModifiedCal.setTimeZone((java.util.TimeZone)vevent.getLastModified().getTimeZone());
        } else {
            lastModifiedCal.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
        }
        lastModifiedCal.setTime((Date)vevent.getLastModified().getDate());
        if (vevent.getRecurrenceId() == null) {
            startReccuringStartSource = null;
        } else {
            startReccuringStartSource = java.util.Calendar.getInstance();
            if (vevent.getRecurrenceId().getTimeZone() != null) {
                startReccuringStartSource.setTimeZone((java.util.TimeZone)vevent.getRecurrenceId().getTimeZone());
            } else {
                startReccuringStartSource.setTimeZone((java.util.TimeZone)timeZoneAllEvent);
            }
            startReccuringStartSource.setTime((Date)vevent.getRecurrenceId().getDate());
        }
        String description = vevent.getDescription() == null ? null : vevent.getDescription().getValue();
        String summary = vevent.getSummary() == null ? null : vevent.getSummary().getValue();
        String uid = vevent.getUid() == null ? null : vevent.getUid().getValue();
        String location = vevent.getLocation() == null ? null : vevent.getLocation().getValue();
        String departement = vevent.getProperty(DEPARTEMENT_PROPERTY) != null ? vevent.getProperty(DEPARTEMENT_PROPERTY).getValue() : "";
        String ville = vevent.getProperty(VILLE_PROPERTY) != null ? vevent.getProperty(VILLE_PROPERTY).getValue() : "";
        String urlInscription = vevent.getProperty(URLINSCRIPTION_PROPERTY) != null ? vevent.getProperty(URLINSCRIPTION_PROPERTY).getValue() : "";
        String dateDebutInscription = vevent.getProperty(DATE_DEBUT_INSCRIPTION_PROPERTY) != null ? vevent.getProperty(DATE_DEBUT_INSCRIPTION_PROPERTY).getValue() : "";
        String dateFinInscription = vevent.getProperty(DATE_FIN_INSCRIPTION_PROPERTY) != null ? vevent.getProperty(DATE_FIN_INSCRIPTION_PROPERTY).getValue() : "";
        List organisateurs = this.getPropertyValues(vevent, ORGANISATEURS_PROPERTY);
        List polesDisciplinaires = this.getPropertyValues(vevent, POLES_DISCIPLINAIRES_PROPERTY);
        List themes = this.getPropertyValues(vevent, THEMES_PROPERTY);
        List niveaux = this.getPropertyValues(vevent, NIVEAUX_PROPERTY);
        List contenus = this.getPropertyValues(vevent, CONTENUS_PROPERTY);
        List reperesDne = this.getPropertyValues(vevent, REPERES_DNE_PROPERTY);
        Date debutInscription = null;
        try {
            debutInscription = dateDebutInscription != null ? sdf.parse(dateDebutInscription) : null;
        }
        catch (ParseException e) {
            logger.error((Object)("Erreur de parsing de la date de debut d'inscription :" + dateDebutInscription + " avec le format " + sdf.toPattern() + "\n URL de synchro : " + url + "\n UID : " + uid));
        }
        Date finInscription = null;
        try {
            finInscription = sdf.parse(dateFinInscription);
        }
        catch (ParseException e) {
            logger.error((Object)("Erreur de parsing de la date de fin d'inscription :" + dateFinInscription + " avec le format " + sdf.toPattern() + "\n URL de synchro : " + url + "\n UID : " + uid));
        }
        InteractikEventToSync eventToSync = new InteractikEventToSync(null, summary, allDay, startCal, endCal, description, idAgenda, uid, createdCal, lastModifiedCal, startReccuringStartSource, location, departement, ville, debutInscription, finInscription, urlInscription);
        eventToSync.setOrganisateurs(organisateurs);
        eventToSync.setPolesDisciplinaires(polesDisciplinaires);
        eventToSync.setThemes(themes);
        eventToSync.setNiveaux(niveaux);
        eventToSync.setContenus(contenus);
        eventToSync.setReperesDne(reperesDne);
        return eventToSync;
    }

    private List<String> getPropertyValues(VEvent vevent, String name) {
        ArrayList<String> results;
        net.fortuna.ical4j.model.PropertyList properties = vevent.getProperties(name);
        if (properties == null || properties.isEmpty()) {
            results = null;
        } else {
            results = new ArrayList<String>(properties.size());
            for (Property property : properties) {
                results.add(property.getValue());
            }
        }
        return results;
    }
}

