/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.integration.portlet.service;

import fr.toutatice.services.calendar.integration.portlet.model.InteractikCalendarIntegrationForm;
import fr.toutatice.services.calendar.integration.portlet.service.InteractikCalendarIntegrationService;
import fr.toutatice.services.calendar.view.portlet.model.Cooperative;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.calendar.integration.portlet.model.CalendarIntegrationForm;
import org.osivia.services.calendar.integration.portlet.service.CalendarIntegrationServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class InteractikCalendarIntegrationServiceImpl
extends CalendarIntegrationServiceImpl
implements InteractikCalendarIntegrationService {
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private IBundleFactory bundleFactory;

    public CalendarIntegrationForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        String path = this.getCalendarPath(portalControllerContext);
        Cooperative selectedCooperative = Cooperative.fromName((String)window.getProperty("selected-cooperative"));
        CalendarIntegrationForm form = super.getForm(portalControllerContext);
        if (form instanceof InteractikCalendarIntegrationForm) {
            InteractikCalendarIntegrationForm interactikForm = (InteractikCalendarIntegrationForm)form;
            LinkedHashMap<Cooperative, String> cooperatives = new LinkedHashMap<Cooperative, String>();
            for (Cooperative cooperative : Cooperative.values()) {
                String url;
                if (selectedCooperative != null && !Cooperative.ACADEMIE.equals((Object)cooperative) && !selectedCooperative.equals((Object)cooperative)) continue;
                ArrayList<String> filters = new ArrayList<String>();
                filters.add(StringEscapeUtils.escapeHtml((String)("agenda=" + cooperative.name())));
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("format", "ics");
                parameters.put("filters", StringUtils.join(filters, (String)"&"));
                try {
                    url = this.portalUrlFactory.getPermaLink(portalControllerContext, "integration", parameters, path, "resource");
                }
                catch (PortalException e) {
                    throw new PortletException((Throwable)e);
                }
                url = StringUtils.replace((String)url, (String)"/commands?", (String)"/commands/events.ics?");
                cooperatives.put(cooperative, url);
            }
            interactikForm.setCooperatives(cooperatives);
        }
        return form;
    }
}

