/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.WindowState;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.PortalUrlType;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.service.CalendarServiceImpl;
import org.osivia.services.calendar.edition.portlet.model.CalendarSynchronizationSource;
import org.osivia.services.calendar.view.portlet.model.CalendarOptions;
import org.osivia.services.calendar.view.portlet.model.CalendarViewForm;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.DailyCalendarEventsData;
import org.osivia.services.calendar.view.portlet.model.events.DailyEvent;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventKey;
import org.osivia.services.calendar.view.portlet.model.events.EventToSync;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.service.CalendarViewService;
import org.osivia.services.calendar.view.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class CalendarViewServiceImpl
extends CalendarServiceImpl
implements CalendarViewService {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ProdId prodId = new ProdId("-//OSIVIA Portal//4.7//FR");
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected CalendarViewRepository repository;
    @Autowired
    private IPortalUrlFactory portalUrlFactory;
    @Autowired
    private INotificationsService notificationsService;
    @Autowired
    private IBundleFactory bundleFactory;

    public String getTitle(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getTitle(portalControllerContext);
    }

    public CalendarData getCalendarData(PortalControllerContext portalControllerContext, String periodTypeName) throws PortletException {
        PeriodTypes periodType = this.getPeriodType(portalControllerContext, periodTypeName);
        ICalendarGenerator generator = this.getGenerator(portalControllerContext, periodType);
        return generator.generateCalendarData(portalControllerContext, periodType);
    }

    protected PeriodTypes getPeriodType(PortalControllerContext portalControllerContext, String periodTypeName) throws PortletException {
        PeriodTypes periodType;
        CalendarOptions configuration = this.repository.getConfiguration(portalControllerContext);
        if (StringUtils.isBlank((String)configuration.getCmsPath())) {
            throw new PortletException(this.getInternationalizedProperty(portalControllerContext, "MESSAGE_CMS_PATH_NOT_DEFINED"));
        }
        if (periodTypeName == null) {
            if (configuration.getPeriodTypeName() != null && !configuration.getPeriodTypeName().isEmpty()) {
                periodTypeName = configuration.getPeriodTypeName();
                periodType = PeriodTypes.fromName((String)periodTypeName);
            } else {
                periodType = PeriodTypes.WEEK;
            }
        } else {
            periodType = PeriodTypes.fromName((String)periodTypeName);
        }
        if (this.isCompact(portalControllerContext) && !periodType.isCompactable()) {
            periodType = PeriodTypes.PLANNING;
        }
        return periodType;
    }

    private ICalendarGenerator getGenerator(PortalControllerContext portalControllerContext, PeriodTypes periodType) throws PortletException {
        ICalendarGenerator result = null;
        Map generators = this.applicationContext.getBeansOfType(ICalendarGenerator.class);
        for (ICalendarGenerator generator : generators.values()) {
            if (!generator.getPeriodType().getViewPath().equals(periodType.getViewPath())) continue;
            result = generator;
            generator.setPeriodType(periodType);
            break;
        }
        return result;
    }

    public boolean isCompact(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarOptions configuration = this.repository.getConfiguration(portalControllerContext);
        boolean maximized = WindowState.MAXIMIZED.equals((Object)portalControllerContext.getRequest().getWindowState());
        return configuration.isCompactView() && !maximized;
    }

    public EventsData getEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        ICalendarGenerator generator = calendarData.getGenerator();
        return generator.generateEventsData(portalControllerContext, calendarData);
    }

    public Event getEvent(PortalControllerContext portalControllerContext, String docid) throws PortletException {
        return this.repository.getEvent(portalControllerContext, docid);
    }

    public String getViewPath(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        PeriodTypes periodType = calendarData.getPeriodType();
        this.repository.insertContentMenubarItems(portalControllerContext);
        String viewPath = periodType.getViewPath();
        if (this.isCompact(portalControllerContext) && periodType.isCompactable()) {
            viewPath = viewPath + "-compact";
        }
        return viewPath;
    }

    protected void addIntegrationMenubarItem(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarOptions options = this.repository.getConfiguration(portalControllerContext);
        if (options.isIntegration()) {
            String url;
            PortletRequest request = portalControllerContext.getRequest();
            Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
            List menubar = (List)request.getAttribute("osivia.menuBar");
            String path = this.repository.getCalendarPath(portalControllerContext);
            if (StringUtils.isEmpty((String)path)) {
                url = null;
            } else {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("format", "ics");
                try {
                    url = this.portalUrlFactory.getPermaLink(portalControllerContext, "integration", parameters, path, "resource");
                }
                catch (PortalException e) {
                    throw new PortletException((Throwable)e);
                }
            }
            if (StringUtils.isNotEmpty(url)) {
                MenubarItem item = new MenubarItem("CALENDAR_INTEGRATION_ICS", bundle.getString("CALENDAR_INTEGRATION_ICS_MENUBAR_ITEM"), null, (MenubarContainer)MenubarGroup.SPECIFIC, 0, url, null, null, null);
                menubar.add(item);
            }
        }
    }

    public String selectPreviousPeriod(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        return this.changeSelectedDate(portalControllerContext, calendarData, -1);
    }

    public String selectNextPeriod(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        return this.changeSelectedDate(portalControllerContext, calendarData, 1);
    }

    private String changeSelectedDate(PortalControllerContext portalControllerContext, CalendarData calendarData, int diff) throws PortletException {
        java.util.Date selectedDate = calendarData.getSelectedDate();
        Calendar calendar = GregorianCalendar.getInstance(portalControllerContext.getRequest().getLocale());
        calendar.setTime(selectedDate);
        calendar.add(calendarData.getPeriodType().getField(), diff);
        selectedDate = calendar.getTime();
        ICalendarGenerator generator = calendarData.getGenerator();
        generator.updateCalendarData(portalControllerContext, calendarData, selectedDate);
        return StringEscapeUtils.escapeHtml((String)SELECTED_DATE_FORMAT.format(selectedDate));
    }

    private String getInternationalizedProperty(PortalControllerContext portalControllerContext, String key) {
        Locale locale = portalControllerContext.getRequest().getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        return bundle.getString(key);
    }

    public void definePortletUri(PortalControllerContext portalControllerContext) throws PortletException {
        this.repository.definePortletUri(portalControllerContext);
    }

    public void save(PortalControllerContext portalControllerContext, CalendarViewForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        try {
            Event event = null;
            if (form.getDocId() != null) {
                event = this.repository.getEvent(portalControllerContext, form.getDocId());
            }
            if (event != null && event.getIdEventSource() != null) {
                this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_NO_RIGHT_SYNCHRO"), NotificationsType.WARNING);
            } else {
                this.repository.save(portalControllerContext, form);
                this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_EVENT_SAVE"), NotificationsType.SUCCESS);
            }
        }
        catch (NuxeoException e) {
            if (1 == e.getErrorCode()) {
                this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_NO_RIGHT"), NotificationsType.WARNING);
            }
            throw e;
        }
    }

    public void synchronize(PortalControllerContext portalControllerContext) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        List listUrlSource = this.repository.getSynchronizationSources(portalControllerContext);
        if (CollectionUtils.isNotEmpty((Collection)listUrlSource)) {
            HashMap<EventKey, EventToSync> mapEvents = new HashMap<EventKey, EventToSync>();
            try {
                for (CalendarSynchronizationSource source : listUrlSource) {
                    URL url = new URL(source.getUrl());
                    URLConnection connection = url.openConnection();
                    CalendarBuilder calendarBuilder = new CalendarBuilder();
                    net.fortuna.ical4j.model.Calendar calendar = calendarBuilder.build(connection.getInputStream());
                    ComponentList listComponent = calendar.getComponents();
                    ComponentList listEvent = listComponent.getComponents("VEVENT");
                    VTimeZone vTimeZoneAllEvent = (VTimeZone)calendar.getComponent("VTIMEZONE");
                    net.fortuna.ical4j.model.TimeZone timeZoneAllEvent = null;
                    if (vTimeZoneAllEvent == null) {
                        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
                        timeZoneAllEvent = registry.getTimeZone("GMT");
                    } else {
                        timeZoneAllEvent = new net.fortuna.ical4j.model.TimeZone(vTimeZoneAllEvent);
                    }
                    for (VEvent event : listEvent) {
                        Calendar cal;
                        if (event.getRecurrenceId() == null) {
                            cal = null;
                        } else {
                            cal = Calendar.getInstance();
                            if (event.getRecurrenceId().getTimeZone() == null) {
                                cal.setTimeZone((TimeZone)timeZoneAllEvent);
                            } else {
                                cal.setTimeZone((TimeZone)event.getRecurrenceId().getTimeZone());
                            }
                            cal.setTime((java.util.Date)event.getRecurrenceId().getDate());
                        }
                        EventKey key = new EventKey(event.getUid().getValue(), source.getId(), cal);
                        mapEvents.put(key, this.buildEvent(event, source.getId(), timeZoneAllEvent));
                    }
                }
                this.repository.synchronize(portalControllerContext, mapEvents);
                this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_SYNCHRO_DONE"), NotificationsType.SUCCESS);
            }
            catch (ParserException e) {
                this.log.error((Object)"Erreur de parsing lors de la synchronisation, d\u00e9tail:");
                e.printStackTrace();
                this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_SYNCHRO_FAILED"), NotificationsType.WARNING);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_SYNCHRO_FAILED_URL"), NotificationsType.WARNING);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_SYNCHRO_FAILED"), NotificationsType.WARNING);
            }
        }
    }

    public void remove(PortalControllerContext portalControllerContext, CalendarViewForm form) throws PortletException {
        Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
        try {
            if (form.getDocId() != null) {
                Event event = this.repository.getEvent(portalControllerContext, form.getDocId());
                if (event.getIdEventSource() != null) {
                    this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_NO_RIGHT_SYNCHRO"), NotificationsType.WARNING);
                } else {
                    this.repository.remove(portalControllerContext, form);
                    this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_DELETE_DONE"), NotificationsType.SUCCESS);
                }
            }
        }
        catch (NuxeoException e) {
            if (1 == e.getErrorCode()) {
                this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_NO_RIGHT"), NotificationsType.WARNING);
            }
            throw e;
        }
    }

    public boolean isEventEditable(PortalControllerContext portalControllerContext, String docid) throws PortletException {
        return this.repository.isEventEditable(portalControllerContext, docid);
    }

    public Map<String, CalendarColor> getSourcesColor(PortalControllerContext portalControllerContext) throws PortletException {
        HashMap<String, CalendarColor> mapSourceColor = new HashMap<String, CalendarColor>();
        mapSourceColor.put("PRIMARY", CalendarColor.fromId((String)this.repository.getColorIdAgenda(portalControllerContext)));
        List listSource = this.repository.getSynchronizationSources(portalControllerContext);
        for (CalendarSynchronizationSource source : listSource) {
            mapSourceColor.put(source.getId(), source.getColor());
        }
        return mapSourceColor;
    }

    public String getColorIdAgenda(PortalControllerContext portalControllerContext) throws PortletException {
        return this.repository.getColorIdAgenda(portalControllerContext);
    }

    public boolean isCalendarReadOnly(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        CalendarOptions options = this.repository.getConfiguration(portalControllerContext);
        boolean anonymousUser = StringUtils.isEmpty((String)request.getRemoteUser());
        return options.isReadOnly() || anonymousUser;
    }

    public JSONArray loadEventsArray(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        EventsData eventsData = this.getEventsData(portalControllerContext, calendarData);
        List listEvent = ((DailyCalendarEventsData)eventsData).getEvents();
        Map mapColor = this.getSourcesColor(portalControllerContext);
        JSONArray array = new JSONArray();
        JSONObject object = null;
        Iterator iterator = listEvent.iterator();
        DailyEvent event = null;
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        SimpleDateFormat formaterAllDay = new SimpleDateFormat("yyyy-MM-dd");
        while (iterator.hasNext()) {
            event = (DailyEvent)iterator.next();
            object = new JSONObject();
            object.put((Object)"text", (Object)event.getTitle());
            if (event.isAllDay()) {
                object.put((Object)"start_date", (Object)formaterAllDay.format(event.getStartDate()));
                object.put((Object)"end_date", (Object)formaterAllDay.format(event.getEndDate()));
            } else {
                object.put((Object)"start_date", (Object)formater.format(event.getStartDate()));
                object.put((Object)"end_date", (Object)formater.format(event.getEndDate()));
            }
            object.put((Object)"doc_id", (Object)event.getId());
            object.put((Object)"color", (Object)event.getBckgColor());
            object.put((Object)"view_url", (Object)event.getViewURL());
            if (event.getBckgColor() == null) {
                if (event.getIdParentSource() == null) {
                    if (mapColor.get("PRIMARY") != null) {
                        object.put((Object)"extraClass", (Object)((CalendarColor)mapColor.get("PRIMARY")).getBackgroundClass());
                    }
                } else if (mapColor.get(event.getIdParentSource()) == null) {
                    object.put((Object)"extraClass", (Object)CalendarColor.DEFAULT);
                } else {
                    object.put((Object)"extraClass", (Object)((CalendarColor)mapColor.get(event.getIdParentSource())).getBackgroundClass());
                }
            } else {
                object.put((Object)"extraClass", (Object)CalendarColor.fromId((String)event.getBckgColor()).getBackgroundClass());
            }
            object.put((Object)"readonly", (Object)this.isEventReadOnly(portalControllerContext, (Event)event));
            array.add((Object)object);
        }
        return array;
    }

    public EventToSync buildEvent(VEvent vevent, String idAgenda, net.fortuna.ical4j.model.TimeZone timeZoneAllEvent) throws PortletException {
        Calendar startReccuringStartSource;
        boolean allDay = vevent.getStartDate().getValue().length() == 8 && vevent.getEndDate().getValue().length() == 8;
        Calendar startCal = Calendar.getInstance();
        if (vevent.getStartDate().getTimeZone() != null) {
            startCal.setTimeZone((TimeZone)vevent.getStartDate().getTimeZone());
        } else {
            startCal.setTimeZone((TimeZone)timeZoneAllEvent);
        }
        startCal.setTime((java.util.Date)vevent.getStartDate().getDate());
        Calendar endCal = Calendar.getInstance();
        if (vevent.getEndDate().getTimeZone() != null) {
            endCal.setTimeZone((TimeZone)vevent.getEndDate().getTimeZone());
        } else {
            endCal.setTimeZone((TimeZone)timeZoneAllEvent);
        }
        endCal.setTime((java.util.Date)vevent.getEndDate().getDate());
        Calendar createdCal = Calendar.getInstance();
        if (vevent.getCreated().getTimeZone() != null) {
            createdCal.setTimeZone((TimeZone)vevent.getCreated().getTimeZone());
        } else {
            createdCal.setTimeZone((TimeZone)timeZoneAllEvent);
        }
        createdCal.setTime((java.util.Date)vevent.getCreated().getDate());
        Calendar lastModifiedCal = Calendar.getInstance();
        if (vevent.getLastModified().getTimeZone() != null) {
            lastModifiedCal.setTimeZone((TimeZone)vevent.getLastModified().getTimeZone());
        } else {
            lastModifiedCal.setTimeZone((TimeZone)timeZoneAllEvent);
        }
        lastModifiedCal.setTime((java.util.Date)vevent.getLastModified().getDate());
        if (vevent.getRecurrenceId() == null) {
            startReccuringStartSource = null;
        } else {
            startReccuringStartSource = Calendar.getInstance();
            if (vevent.getRecurrenceId().getTimeZone() != null) {
                startReccuringStartSource.setTimeZone((TimeZone)vevent.getRecurrenceId().getTimeZone());
            } else {
                startReccuringStartSource.setTimeZone((TimeZone)timeZoneAllEvent);
            }
            startReccuringStartSource.setTime((java.util.Date)vevent.getRecurrenceId().getDate());
        }
        String description = vevent.getDescription() == null ? null : vevent.getDescription().getValue();
        String summary = vevent.getSummary() == null ? null : vevent.getSummary().getValue();
        String uid = vevent.getUid() == null ? null : vevent.getUid().getValue();
        String location = vevent.getLocation() == null ? null : vevent.getLocation().getValue();
        return new EventToSync(null, summary, allDay, startCal, endCal, description, idAgenda, uid, createdCal, lastModifiedCal, startReccuringStartSource, location);
    }

    protected boolean isEventReadOnly(PortalControllerContext portalControllerContext, Event event) throws PortletException {
        boolean synchronizedEvent = StringUtils.isNotEmpty((String)event.getIdEventSource());
        return synchronizedEvent || this.isCalendarReadOnly(portalControllerContext);
    }

    public void integrate(PortalControllerContext portalControllerContext, OutputStream outputStream, String format) throws PortletException, IOException {
        net.fortuna.ical4j.model.Calendar calendar = new net.fortuna.ical4j.model.Calendar();
        calendar.getProperties().add((Property)this.prodId);
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        List events = this.repository.getEvents(portalControllerContext, null, null);
        if (CollectionUtils.isNotEmpty((Collection)events)) {
            for (Event event : events) {
                VEvent vevent = this.createVEvent(portalControllerContext, event);
                if (vevent == null) continue;
                calendar.getComponents().add((Object)vevent);
            }
        }
        CalendarOutputter outputter = new CalendarOutputter();
        outputter.output(calendar, outputStream);
    }

    protected VEvent createVEvent(PortalControllerContext portalControllerContext, Event event) throws PortletException, IOException {
        VEvent vevent;
        Date start;
        if (event.getStartDate() == null) {
            start = null;
        } else if (event.isAllDay()) {
            start = new Date(event.getStartDate());
        } else {
            DateTime dateTime = new DateTime(event.getStartDate());
            dateTime.setUtc(true);
            start = dateTime;
        }
        String summary = event.getTitle();
        if (start != null && StringUtils.isNotEmpty((String)summary)) {
            vevent = new VEvent(start, summary);
            PropertyList properties = vevent.getProperties();
            if (event.getEndDate() != null) {
                DtEnd end;
                if (event.isAllDay()) {
                    end = new DtEnd(new Date(event.getEndDate()));
                } else {
                    end = new DtEnd((Date)new DateTime(event.getEndDate()));
                    end.setUtc(true);
                }
                properties.add((Property)end);
            }
            if (StringUtils.isNotEmpty((String)event.getId())) {
                Uid uid = new Uid(event.getId());
                properties.add((Property)uid);
            }
            if (event.getLastModified() != null) {
                LastModified lastModified = new LastModified(new DateTime(event.getLastModified()));
                properties.add((Property)lastModified);
            }
            if (StringUtils.isNotBlank((String)event.getLocation())) {
                Location location = new Location(event.getLocation());
                properties.add((Property)location);
            }
            if (StringUtils.isNotBlank((String)event.getDescription())) {
                Description description = new Description(event.getDescription());
                properties.add((Property)description);
            }
        } else {
            vevent = null;
        }
        return vevent;
    }

    public String getIntegrationUrl(PortalControllerContext portalControllerContext) throws PortletException {
        String url;
        CalendarOptions options = this.repository.getConfiguration(portalControllerContext);
        if (options.isIntegration()) {
            String path = this.repository.getCalendarPath(portalControllerContext);
            String instance = "osivia-services-calendar-integration-instance";
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("osivia.cms.uri", path);
            try {
                url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, instance, properties, PortalUrlType.MODAL);
            }
            catch (PortalException e) {
                throw new PortletException((Throwable)e);
            }
        } else {
            url = null;
        }
        return url;
    }
}

