<%@ page import="java.util.Date"%>
<%@ page import="fr.toutatice.services.calendar.view.portlet.model.calendar.InteractikCalendarData"%>
<%@ page import="org.apache.commons.lang.time.DateUtils"%>
<%@ page import="java.text.SimpleDateFormat"%>
<%@ page import="org.codehaus.jackson.map.introspect.BasicClassIntrospector.GetterMethodFilter"%>

<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.osivia.org/jsp/taglib/osivia-portal" prefix="op" %>
<%@ taglib uri="http://www.springframework.org/tags/form" prefix="form"%>

<%@ page contentType="text/html" isELIgnored="false"%>


<% 
	InteractikCalendarData calendarData = (InteractikCalendarData)request.getAttribute("calendarData"); 
	SimpleDateFormat formater = new SimpleDateFormat("yyyy,MM,dd");
%>

<portlet:defineObjects />

<portlet:resourceURL id="initSchedulerData" var="initData" />
<portlet:resourceURL id="loadData" var="loadData">
    <portlet:param name="cooperative22" value="${InteractikFilters.cooperative22}" />
    <portlet:param name="cooperative29" value="${InteractikFilters.cooperative29}" />
    <portlet:param name="cooperative35" value="${InteractikFilters.cooperative35}" />
    <portlet:param name="cooperative56" value="${InteractikFilters.cooperative56}" /> 
    <portlet:param name="cooperativeAcademie" value="${InteractikFilters.cooperativeAcademie}" /> 
</portlet:resourceURL>
<portlet:resourceURL id="isEventEditable" var="isEventEditable" />
<portlet:actionURL name="synchronize" var="synchronize">
	<portlet:param name="period" value="${calendarData.periodType.name}" />
	<portlet:param name="date" value="${calendarData.startDateToString}" />
</portlet:actionURL >
<portlet:actionURL name="dragndrop" var="dragndrop">
    <portlet:param name="cooperative22" value="${InteractikFilters.cooperative22}" />
    <portlet:param name="cooperative29" value="${InteractikFilters.cooperative29}" />
    <portlet:param name="cooperative35" value="${InteractikFilters.cooperative35}" />
    <portlet:param name="cooperative56" value="${InteractikFilters.cooperative56}" /> 
    <portlet:param name="cooperativeAcademie" value="${InteractikFilters.cooperativeAcademie}" /> 
	<portlet:param name="period" value="${calendarData.periodType.name}" />
	<portlet:param name="date" value="${calendarData.startDateToString}" />
</portlet:actionURL >
<portlet:actionURL name="remove" var="remove">
	<portlet:param name="period" value="${calendarData.periodType.name}" />
	<portlet:param name="date" value="${calendarData.startDateToString}" />
</portlet:actionURL >
<portlet:actionURL name="viewEvent"  var="viewEvent" />
<portlet:actionURL name="search"     var="search"    >
	<portlet:param name="period" value="${calendarData.periodType.name}" />
	<portlet:param name="date" value="${calendarData.startDateToString}" />
</portlet:actionURL>

<portlet:renderURL var="next">
    <portlet:param name="period" value="${calendarData.periodType.name}" />
    <portlet:param name="cooperative22" value="${InteractikFilters.cooperative22}" />
    <portlet:param name="cooperative29" value="${InteractikFilters.cooperative29}" />
    <portlet:param name="cooperative35" value="${InteractikFilters.cooperative35}" />
    <portlet:param name="cooperative56" value="${InteractikFilters.cooperative56}" /> 
    <portlet:param name="cooperativeAcademie" value="${InteractikFilters.cooperativeAcademie}" />     
    <c:choose>
        <c:when test="${'day' eq calendarData.periodType.name}">
            <portlet:param name="date" value="<%=formater.format(DateUtils.addDays(calendarData.getStartDate(),1))%>" />
        </c:when>
        <c:when test="${'week' eq calendarData.periodType.name}">
            <portlet:param name="date" value="<%=formater.format(DateUtils.addDays(calendarData.getStartDate(),7))%>" />
        </c:when>
        <c:when test="${'month' eq calendarData.periodType.name}">
            <portlet:param name="date" value="<%=formater.format(DateUtils.addMonths(calendarData.getStartDate(),1))%>" />
        </c:when>
    </c:choose>
</portlet:renderURL>
<portlet:renderURL var="previous">
    <portlet:param name="period" value="${calendarData.periodType.name}" />
    <portlet:param name="cooperative22" value="${InteractikFilters.cooperative22}" />
    <portlet:param name="cooperative29" value="${InteractikFilters.cooperative29}" />
    <portlet:param name="cooperative35" value="${InteractikFilters.cooperative35}" />
    <portlet:param name="cooperative56" value="${InteractikFilters.cooperative56}" /> 
    <portlet:param name="cooperativeAcademie" value="${InteractikFilters.cooperativeAcademie}" />     
    <c:choose>
        <c:when test="${'day' eq calendarData.periodType.name}">
            <portlet:param name="date" value="<%=formater.format(DateUtils.addDays(calendarData.getStartDate(),-1))%>" />
        </c:when>
        <c:when test="${'week' eq calendarData.periodType.name}">
            <portlet:param name="date" value="<%=formater.format(DateUtils.addDays(calendarData.getStartDate(),-7))%>" />
        </c:when>
        <c:when test="${'month' eq calendarData.periodType.name}">
            <portlet:param name="date" value="<%=formater.format(DateUtils.addMonths(calendarData.getStartDate(),-1))%>" />
        </c:when>
    </c:choose>
</portlet:renderURL>
<portlet:renderURL var="today">
    <portlet:param name="period" value="${calendarData.periodType.name}" /> 
    <portlet:param name="cooperative22" value="${InteractikFilters.cooperative22}" />
    <portlet:param name="cooperative29" value="${InteractikFilters.cooperative29}" />
    <portlet:param name="cooperative35" value="${InteractikFilters.cooperative35}" />
    <portlet:param name="cooperative56" value="${InteractikFilters.cooperative56}" /> 
    <portlet:param name="cooperativeAcademie" value="${InteractikFilters.cooperativeAcademie}" />       
</portlet:renderURL>
<portlet:renderURL var="viewDay">
    <portlet:param name="period" value="day" />
    <portlet:param name="cooperative22" value="${InteractikFilters.cooperative22}" />
    <portlet:param name="cooperative29" value="${InteractikFilters.cooperative29}" />
    <portlet:param name="cooperative35" value="${InteractikFilters.cooperative35}" />
    <portlet:param name="cooperative56" value="${InteractikFilters.cooperative56}" /> 
    <portlet:param name="cooperativeAcademie" value="${InteractikFilters.cooperativeAcademie}" />     
    <portlet:param name="date" value="<%=formater.format(request.getAttribute("dayForViewDay"))%>" />
</portlet:renderURL>
<portlet:renderURL var="viewWeek">
    <portlet:param name="period" value="week" />
    <portlet:param name="cooperative22" value="${InteractikFilters.cooperative22}" />
    <portlet:param name="cooperative29" value="${InteractikFilters.cooperative29}" />
    <portlet:param name="cooperative35" value="${InteractikFilters.cooperative35}" />
    <portlet:param name="cooperative56" value="${InteractikFilters.cooperative56}" /> 
    <portlet:param name="cooperativeAcademie" value="${InteractikFilters.cooperativeAcademie}" /> 
    <portlet:param name="date" value="<%=formater.format(request.getAttribute("dayForViewWeek"))%>" />
</portlet:renderURL>
<portlet:renderURL var="viewMonth">
    <portlet:param name="period" value="month" />
    <portlet:param name="cooperative22" value="${InteractikFilters.cooperative22}" />
    <portlet:param name="cooperative29" value="${InteractikFilters.cooperative29}" />
    <portlet:param name="cooperative35" value="${InteractikFilters.cooperative35}" />
    <portlet:param name="cooperative56" value="${InteractikFilters.cooperative56}" /> 
    <portlet:param name="cooperativeAcademie" value="${InteractikFilters.cooperativeAcademie}" />     
    <portlet:param name="date" value="<%=formater.format(request.getAttribute("dayForViewMonth"))%>" />
</portlet:renderURL>
<portlet:renderURL var="viewPlanning">
    <portlet:param name="period" value="planning" />
    <portlet:param name="date" value="<%=formater.format(request.getAttribute("dayForViewDay"))%>" />
</portlet:renderURL>
 
<c:set var="namespace"><portlet:namespace /></c:set>

 
<div class="interactik-calendar">
    <!-- Vue semaine -->
    <div id="scheduler_here" class="dhx_cal_container"
    	data-period="${calendarData.periodType.name}" 
        data-startdate="${calendarData.startDate.time}"
        data-url="${loadData}"
        data-url-dragndrop="${dragndrop}"
        data-url-remove="${remove}"
        data-url-viewevent="${viewEvent}"
        data-scrollviewdayweek="${calendarData.scrollViewDayWeek}"
        data-scrollviewmonth="${calendarData.scrollViewMonth}"
        data-url-eventeditable="${isEventEditable}"
        data-url-synchronize="${synchronize}"
        data-color-main-agenda="${calendarData.agendaBackgroundColor}"
        data-read-only="${calendarData.readOnly}"
        data-namespace="${namespace}"
        data-agenda-interactik="true"
        data-first-hour="7">
        
        <div class="dhx_cal_navline btn-toolbar" role="toolbar">
            <div class="btn-group btn-group-sm" role="group">
                <!-- Previous period -->
                <a href="${previous}" onclick="this.href=addScrollParam(this.href,null);" class="btn btn-default">
                    <i class="halflings halflings-chevron-left"></i>
                    <span class="sr-only"><op:translate key="CALENDAR_PREVIOUS_PERIOD" /></span>
                </a>
                
                <!-- Next period -->
                <a href="${next}" onclick="this.href=addScrollParam(this.href,null);" class="btn btn-default">
                    <i class="halflings halflings-chevron-right"></i>
                    <span class="sr-only"><op:translate key="CALENDAR_NEXT_PERIOD" /></span>
                </a>
            </div>
            
            <div class="btn-group btn-group-sm" role="group">
                <!-- Today -->
                <a href="${today}" onclick="this.href=addScrollParam(this.href,null);" class="btn btn-default">
                    <span><op:translate key="CALENDAR_TODAY" /></span>
                </a>
            </div>
            
            <div class="btn-group btn-group-sm pull-right" role="group">
                <!-- Coop�ratives -->
                <div class="btn-group btn-group-sm dropdown ${calendarData.displayCooperatives ? '' : 'hidden'}" role="group">
                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                        <span><op:translate key="TIK_CALENDAR_CHOOSE_COOPERATIVE" /></span>
                        <span class="caret"></span>
                    </button>
                    
                    <ul class="dropdown-menu dropdown-menu-right">
                        <li class="dropdown-header" role="presentation"><op:translate key="TIK_CALENDAR_CHOOSE_COOPERATIVE_TITLE" /></li>
                    
                        <li>
                            <form:form role="search" method="post" action="${search}" modelAttribute="InteractikFilters">
                                <div class="checkbox">
                                	<label>
                               		 	<form:checkbox path="cooperative22" /><span><op:translate key="TIK_COOPERATIVE_22" /></span>
                               		</label>
                               	</div>
                                <div class="checkbox">
                                	<label>
                               		 	<form:checkbox path="cooperative29" /><span><op:translate key="TIK_COOPERATIVE_29" /></span>
                               		</label>
                               	</div>
                                <div class="checkbox">
                                	<label>
                               		 	<form:checkbox path="cooperative35" /><span><op:translate key="TIK_COOPERATIVE_35" /></span>
                               		</label>
                               	</div>
                                <div class="checkbox">
                                	<label>
                               		 	<form:checkbox path="cooperative56" /><span><op:translate key="TIK_COOPERATIVE_56" /></span>
                               		</label>
                               	</div>
                                <div class="checkbox">
                                	<label>
                               		 	<form:checkbox path="cooperativeAcademie"/><span><op:translate key="TIK_COOPERATIVE_ACADEMIE" /></span>
                               		</label>
                               	</div>                               	                               	                               	                               	
                                <!-- Button -->
       						   	<button type="submit" class="btn-block" style="margin-top: 20px;">
            				   		 <op:translate key="TIK_CALENDAR_COOPERATIVE_VALIDATION" />
        					    </button>
                            </form:form>
                        </li>
                    </ul>
                </div>
            
                <!-- View -->
                <div class="btn-group btn-group-sm dropdown" role="group">
                    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                        <span><op:translate key="${calendarData.periodType.internationalizationKey}" /></span>
                        <span class="caret"></span>
                    </button>
                    
                    <ul class="dropdown-menu dropdown-menu-right">
                        <li>
                            <a href="${viewDay}" class="dropdown-item" onclick="this.href=addScrollParam(this.href,'day');">
                                <span><op:translate key="CALENDAR_DAY" /></span>
                            </a>
                        </li>
                        <li>
                            <a href="${viewWeek}" class="dropdown-item" onclick="this.href=addScrollParam(this.href,'week');">
                                <span><op:translate key="CALENDAR_WEEK" /></span>
                            </a>
                        </li>
                        <li>
                            <a href="${viewMonth}" class="dropdown-item" onclick="this.href=addScrollParam(this.href,'month');">
                                <span><op:translate key="CALENDAR_MONTH" /></span>
                            </a>
                        </li>
                        <li>
                            <a href="${viewPlanning}" class="dropdown-item">
                                <span><op:translate key="CALENDAR_PLANNING" /></span>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
            
            <div class="dhx_cal_date hidden-xs"></div>
        </div>
        
        <div class="dhx_cal_header small"></div>
        <div class="dhx_cal_data small"></div><!-- Ajout de la classe portlet-filler pour que la hauteur soit d�finie automatiquement avec la place restante -->       
    </div>
    
    
    <!-- Add event -->
    <c:if test="${not calendarData.readOnly}">
        <portlet:actionURL name="addEvent" var="url" />
        <c:set var="title"><op:translate key="TIK_CALENDAR_ADD_EVENT" /></c:set>
        <div class="interactik-add-event">
            <a href="${url}" title="${title}" data-toggle="tooltip" data-placement="left">
                <i class="glyphicons glyphicons-plus"></i>
                <span class="sr-only">${title}</span>
            </a>
        </div>
    </c:if>


    <%--Integration--%>
    <c:if test="${not empty calendarData.integrationUrl}">
        <div class="interactik-integration">
            <a href="javascript:" class="no-ajax-link" data-target="#osivia-modal" data-load-url="${calendarData.integrationUrl}">
                <span><op:translate key="TIK_CALENDAR_INTEGRATE" /></span>
            </a>
        </div>
    </c:if>
</div>
