/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.view.portlet.model.CalendarEditionMode;
import org.osivia.services.calendar.view.portlet.model.CalendarViewForm;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.service.CalendarViewService;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class ViewCalendarController {
    private static final String ERROR_PATH = "error";
    protected static final String CALENDAR_DATA_ATTRIBUTE = "calendarData";
    private static final String EVENTS_DATA_ATTRIBUTE = "eventsData";
    private static final String ERROR_MESSAGE_ATTRIBUTE = "message";
    private static final String DAY_FOR_VIEW_DAY = "dayForViewDay";
    private static final String DAY_FOR_VIEW_WEEK = "dayForViewWeek";
    private static final String DAY_FOR_VIEW_MONTH = "dayForViewMonth";
    private static final String SCROLL_DAY_WEEK_PARAMETER = "scrollViewDayWeek";
    private static final String SCROLL_MONTH_PARAMETER = "scrollViewMonth";
    @Autowired
    protected PortletContext portletContext;
    @Autowired
    protected CalendarViewService calendarService;
    @Autowired
    private IPortalUrlFactory urlFactory;
    @Autowired
    protected IBundleFactory bundleFactory;
    @Autowired
    protected INotificationsService notificationsService;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @RequestParam(value="date", required=false) String startDate, @RequestParam(value="period", required=false) String periodType, @RequestParam(value="scrollViewDayWeek", required=false) String scrollViewDayWeek, @RequestParam(value="scrollViewMonth", required=false) String scrollViewMonth, @ModelAttribute CalendarData calendarData) throws PortletException {
        String title;
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (null != periodType) {
            calendarData.setPeriodType(PeriodTypes.fromName((String)periodType));
        }
        if (null != startDate) {
            try {
                calendarData.setStartDate(CalendarViewService.SELECTED_DATE_FORMAT.parse(startDate));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (PeriodTypes.PLANNING.getName().equals(calendarData.getPeriodType().getName())) {
            request.setAttribute(EVENTS_DATA_ATTRIBUTE, (Object)this.calendarService.getEventsData(portalControllerContext, calendarData));
        }
        if (StringUtils.isNotBlank((String)(title = this.calendarService.getTitle(portalControllerContext)))) {
            response.setTitle(title);
        }
        Calendar calendar = Calendar.getInstance();
        int currentMonthOfYear = calendar.get(2);
        int currentWeekOfYear = calendar.get(3);
        calendar.setTime(calendarData.getStartDate());
        int startDateMonthOfYear = calendar.get(2);
        int startDateWeekOfYear = calendar.get(3);
        Calendar calFirstDayOfWeek = Calendar.getInstance();
        calFirstDayOfWeek.set(7, 2);
        Date firstDayOfCurrentWeek = calFirstDayOfWeek.getTime();
        calFirstDayOfWeek.setTime(calendarData.getStartDate());
        calFirstDayOfWeek.set(7, 2);
        Date firstDayOfWeek = calFirstDayOfWeek.getTime();
        calendar.setTime(calendarData.getStartDate());
        calendar.set(5, 1);
        Date firstDayOfMonth = calendar.getTime();
        Date dayForViewDay = null;
        Date dayForViewWeek = null;
        Date dayForViewMonth = null;
        Date today = Calendar.getInstance().getTime();
        if (PeriodTypes.MONTH.getName().equals(calendarData.getPeriodType().getName())) {
            if (currentMonthOfYear == startDateMonthOfYear) {
                dayForViewDay = today;
                dayForViewWeek = firstDayOfCurrentWeek;
            } else {
                dayForViewDay = firstDayOfMonth;
                dayForViewWeek = firstDayOfMonth;
            }
            dayForViewMonth = firstDayOfMonth;
        } else if (PeriodTypes.WEEK.getName().equals(calendarData.getPeriodType().getName())) {
            dayForViewDay = currentWeekOfYear == startDateWeekOfYear ? today : firstDayOfWeek;
            dayForViewWeek = calendarData.getStartDate();
            dayForViewMonth = firstDayOfMonth;
        } else {
            dayForViewDay = calendarData.getStartDate();
            dayForViewWeek = firstDayOfWeek;
            if (calendarData.getEndDate() != null) {
                calendar.setTime(calendarData.getEndDate());
                calendar.set(5, 1);
                dayForViewMonth = calendar.getTime();
            } else {
                dayForViewMonth = dayForViewWeek;
            }
        }
        if (scrollViewDayWeek != null) {
            request.getPortletSession().setAttribute(SCROLL_DAY_WEEK_PARAMETER, (Object)scrollViewDayWeek);
            calendarData.setScrollViewDayWeek(scrollViewDayWeek);
        } else if (request.getPortletSession().getAttribute(SCROLL_DAY_WEEK_PARAMETER) == null) {
            calendarData.setScrollViewDayWeek("-1");
        } else {
            calendarData.setScrollViewDayWeek((String)request.getPortletSession().getAttribute(SCROLL_DAY_WEEK_PARAMETER));
        }
        if (scrollViewMonth != null) {
            request.getPortletSession().setAttribute(SCROLL_MONTH_PARAMETER, (Object)scrollViewMonth);
            calendarData.setScrollViewMonth(scrollViewMonth);
        } else if (request.getPortletSession().getAttribute(SCROLL_MONTH_PARAMETER) == null) {
            calendarData.setScrollViewMonth("-1");
        } else {
            calendarData.setScrollViewMonth((String)request.getPortletSession().getAttribute(SCROLL_MONTH_PARAMETER));
        }
        request.setAttribute(DAY_FOR_VIEW_DAY, (Object)dayForViewDay);
        request.setAttribute(DAY_FOR_VIEW_WEEK, (Object)dayForViewWeek);
        request.setAttribute(DAY_FOR_VIEW_MONTH, (Object)dayForViewMonth);
        request.setAttribute(CALENDAR_DATA_ATTRIBUTE, (Object)calendarData);
        String colorIdAgenda = this.calendarService.getColorIdAgenda(portalControllerContext);
        calendarData.setAgendaBackgroundColor(CalendarColor.fromId((String)colorIdAgenda).getBackgroundClass());
        boolean readOnly = this.calendarService.isCalendarReadOnly(portalControllerContext);
        calendarData.setReadOnly(readOnly);
        this.calendarService.definePortletUri(portalControllerContext);
        return this.calendarService.getViewPath(portalControllerContext, calendarData);
    }

    @ResourceMapping(value="initSchedulerData")
    public void initSchedulerData(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="calendarData") CalendarData calendarData, @RequestParam(value="period", required=false) String periodTypeName, @RequestParam(value="date", required=false) Date selectedDate) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.dataLoading(response, portalControllerContext, calendarData);
    }

    @ResourceMapping(value="loadData")
    public void loadData(ResourceRequest request, ResourceResponse response, @ModelAttribute(value="calendarData") CalendarData calendarData, @RequestParam(value="start") Date startDate, @RequestParam(value="end") Date endDate) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        calendarData.setStartDate(startDate);
        if (endDate != null) {
            calendarData.setEndDate(endDate);
        }
        this.dataLoading(response, portalControllerContext, calendarData);
    }

    @ResourceMapping(value="isEventEditable")
    public void isEventEditable(ResourceRequest request, ResourceResponse response, @RequestParam(value="id", required=true) String id) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        Boolean isEventEditable = new Boolean(this.calendarService.isEventEditable(portalControllerContext, id));
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(isEventEditable.toString());
        printWriter.close();
    }

    @ActionMapping(value="viewEvent")
    public void viewEvent(ActionRequest request, ActionResponse response, PortletSession session, @RequestParam(value="doc_id") String docid, @RequestParam(value="scrollViewDayWeek", required=false) String scrollViewDayWeek, @RequestParam(value="scrollViewMonth", required=false) String scrollViewMonth) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (scrollViewDayWeek == null) {
            scrollViewDayWeek = "-1";
        }
        if (scrollViewMonth == null) {
            scrollViewMonth = "-1";
        }
        session.setAttribute(SCROLL_DAY_WEEK_PARAMETER, (Object)scrollViewDayWeek);
        session.setAttribute(SCROLL_MONTH_PARAMETER, (Object)scrollViewMonth);
        Event event = this.calendarService.getEvent(portalControllerContext, docid);
        response.sendRedirect(event.getViewURL());
    }

    @ActionMapping(value="dragndrop")
    public void dragndrop(ActionRequest request, ActionResponse response, PortletSession session, @RequestParam(value="start") String startDate, @RequestParam(value="end") String endDate, @RequestParam(value="doc_id") String docid, @RequestParam(value="title") String title, @RequestParam(value="timezone") String timezoneName, @RequestParam(value="scrollViewDayWeek", required=false) String scrollViewDayWeek, @RequestParam(value="scrollViewMonth", required=false) String scrollViewMonth, @RequestParam(value="period") String period, @RequestParam(value="date") String date) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CalendarViewForm form = new CalendarViewForm();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        df1.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            form.setEndDate(df1.parse(endDate));
            form.setStartDate(df1.parse(startDate));
            form.setTitle(title);
            if ("undefined".equals(docid)) {
                form.setDocId(null);
                form.setMode(CalendarEditionMode.CREATION);
            } else {
                form.setDocId(docid);
                form.setMode(CalendarEditionMode.EDITION);
            }
            TimeZone timezone = null;
            timezone = timezoneName.isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone(timezoneName);
            this.calendarService.save(portalControllerContext, form, timezone);
        }
        catch (ParseException e) {
            Bundle bundle = this.bundleFactory.getBundle(portalControllerContext.getRequest().getLocale());
            this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("MESSAGE_EVENT_NOT_SAVE"), NotificationsType.WARNING);
        }
        this.setResponseParameter(response, date, period, scrollViewDayWeek, scrollViewMonth);
    }

    @ActionMapping(value="remove")
    public void remove(ActionRequest request, ActionResponse response, PortletSession session, @RequestParam(value="doc_id") String docid, @RequestParam(value="scrollViewDayWeek", required=false) String scrollViewDayWeek, @RequestParam(value="scrollViewMonth", required=false) String scrollViewMonth, @RequestParam(value="period") String period, @RequestParam(value="date") String date) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        CalendarViewForm form = new CalendarViewForm();
        if (!"undefined".equals(docid)) {
            form.setDocId(docid);
            this.calendarService.remove(portalControllerContext, form);
        }
        this.setResponseParameter(response, date, period, scrollViewDayWeek, scrollViewMonth);
    }

    @ActionMapping(value="synchronize")
    public void synchronize(ActionRequest request, ActionResponse response, PortletSession session) throws PortletException, IOException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.calendarService.synchronize(portalControllerContext);
        response.sendRedirect(this.urlFactory.getRefreshPageUrl(portalControllerContext));
    }

    @ModelAttribute(value="calendarData")
    public CalendarData getCalendarData(PortletRequest request, PortletResponse response, @RequestParam(value="period", required=false) String periodTypeName) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.calendarService.getCalendarData(portalControllerContext, periodTypeName);
    }

    @ExceptionHandler(value={Exception.class})
    public String handleException(PortletRequest request, PortletResponse response, Exception exception) {
        request.setAttribute(ERROR_MESSAGE_ATTRIBUTE, (Object)exception.getMessage());
        return ERROR_PATH;
    }

    protected void dataLoading(ResourceResponse response, PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException, IOException {
        JSONArray array = this.calendarService.loadEventsArray(portalControllerContext, calendarData);
        response.setContentType("application/json");
        PrintWriter printWriter = new PrintWriter(response.getPortletOutputStream());
        printWriter.write(array.toString());
        printWriter.close();
    }

    protected void setResponseParameter(ActionResponse response, String date, String period, String scrollViewDayWeek, String scrollViewMonth) {
        response.setRenderParameter("date", date);
        response.setRenderParameter("period", period);
        if (scrollViewDayWeek == null) {
            scrollViewDayWeek = "-1";
        }
        if (scrollViewMonth == null) {
            scrollViewMonth = "-1";
        }
        response.setRenderParameter(SCROLL_DAY_WEEK_PARAMETER, scrollViewDayWeek);
        response.setRenderParameter(SCROLL_MONTH_PARAMETER, scrollViewMonth);
    }
}

