<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="http://www.osivia.org/jsp/taglib/osivia-portal" prefix="op" %>
<%@ taglib uri="http://www.toutatice.fr/jsp/taglib/toutatice" prefix="ttc" %>

<%@ page contentType="text/html" isELIgnored="false"%>


<div class="interactik-calendar-event-view">
    <!-- Date -->
    <div class="schedule">
        <strong>${form.formattedDate}</strong>
        <span>-</span>
        <span>${form.formattedTime}</span>
    </div>
    
    <div class="infos">
        <div class="infos-header">
            <!-- Title -->
            <h3 class="text-uppercase">
                <strong><ttc:title document="${form.document}" /></strong>
            </h3>
            
            <!-- Location -->
            <p class="text-pre-wrap">${form.document.properties['vevent:location']}</p>
        </div>
    
        <div class="row">
            <div class="col-sm-6">
                <!-- Actions -->
                <%@ include file="actions.jspf" %>
                
                <dl class="dl-horizontal">
                    <!-- Organisateurs -->
                    <%@ include file="organisateurs.jspf" %>
                    <!-- Ples disciplinaires -->
                    <%@ include file="poles-disciplinaires.jspf"%>
                    <!-- Niveaux -->
                    <%@ include file="niveaux.jspf"%>
                    <!-- Thmes -->
                    <%@ include file="themes.jspf"%>
                    <!-- Contenus -->
                    <%@ include file="contenus.jspf"%>
                </dl>
            </div>
            
            <div class="col-sm-6">
                <!-- Picture -->
                <%@ include file="picture.jspf" %>
            </div>
        </div>
        
        <!-- Content -->
        <p class="text-uppercase">
            <strong><op:translate key="TIK_CALENDAR_EVENT_PROGRAM" /></strong>
        </p>
        <div class="content"><ttc:transform document="${form.document}" property="note:note" /></div>
    </div>
</div>


<div class="interactik-calendar-event-view-back">
    <a href="javascript:window.history.back()" class="no-ajax-link">
        <i class="glyphicons glyphicons-chevron-left"></i>
        <span><op:translate key="TIK_CALENDAR_EVENT_BACK"/></span>
    </a>
</div>
