package fr.toutatice.services.calendar.event.edition.portlet.controller;

import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.event.edition.portlet.controller.CalendarEventEditionController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventVocabularies;
import fr.toutatice.services.calendar.event.edition.portlet.service.InteractikCalendarEventEditionService;

/**
 * Interactik calendar event edition portlet controller.
 *
 * @author Cédric Krommenhoek
 * @see CalendarEventEditionController
 */
@Controller
@RequestMapping("VIEW")
@Primary
public class InteractikCalendarEventEditionController extends CalendarEventEditionController {

    /** Portlet context. */
    @Autowired
    private PortletContext portletContext;

    /** Portlet service. */
    @Autowired
    private InteractikCalendarEventEditionService service;


    /**
     * Constructor.
     */
    public InteractikCalendarEventEditionController() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute("options") CalendarEditionOptions options) throws PortletException {
        super.view(request, response, options);

        return "view-interactik";
    }


    /**
     * Get vocabularies model attribute.
     * 
     * @param request portlet request
     * @param response portlet response
     * @return vocabularies
     * @throws PortletException
     */
    @ModelAttribute("vocabularies")
    public InteractikCalendarEventVocabularies getVocabularies(PortletRequest request, PortletResponse response) throws PortletException {
        // Portal controller context
        PortalControllerContext portalControllerContext = new PortalControllerContext(portletContext, request, response);
        
        return this.service.getVocabularies(portalControllerContext);
    }

}
