package fr.toutatice.services.calendar.event.edition.portlet.repository;

import javax.portlet.PortletException;

import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.event.edition.portlet.repository.CalendarEventEditionRepository;

import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventVocabularies;

/**
 * Interactik calendar event edition portlet repository interface.
 * 
 * @author Cédric Krommenhoek
 * @see CalendarEventEditionRepository
 */
public interface InteractikCalendarEventEditionRepository extends CalendarEventEditionRepository {

    /** Organisateurs vocabulary name. */
    String ORGANISATEURS_VOCABULARY_NAME = "interactik-organisateur";
    /** Pôles disciplinaires vocabulary name. */
    String POLES_DISCIPLINAIRES_VOCABULARY_NAME = "interactik-pole-disciplinaire";
    /** Thèmes vocabulary name. */
    String THEMES_VOCABULARY_NAME = "interactik-theme";
    /** Niveaux vocabulary name. */
    String NIVEAUX_VOCABULARY_NAME = "interactik-niveau";
    /** Contenus vocabulary name. */
    String CONTENUS_VOCABULARY_NAME = "interactik-contenu";
    /** Repères DNE vocabulary name. */
    String REPERES_DNE_VOCABULARY_NAME = "interactik-reperes-dne";


    /**
     * Initialize vocabularies.
     * 
     * @param portalControllerContext portal controller context
     * @param vocabularies vocabularies
     * @throws PortletException
     */
    void initializeVocabularies(PortalControllerContext portalControllerContext, InteractikCalendarEventVocabularies vocabularies) throws PortletException;

}
