package fr.toutatice.services.calendar.event.view.portlet.controller;

import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

import org.osivia.services.calendar.event.view.portlet.controller.CalendarEventViewController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

import fr.toutatice.services.calendar.event.view.portlet.service.InteractikCalendarEventViewService;

/**
 * Interactik calendar event view portlet controller.
 *
 * @author Cédric Krommenhoek
 * @see CalendarEventViewController
 */
@Controller
@Primary
@RequestMapping("VIEW")
public class InteractikCalendarEventViewController extends CalendarEventViewController {

    /** Portlet context. */
    @Autowired
    private PortletContext portletContext;

    /** Portlet service. */
    @Autowired
    private InteractikCalendarEventViewService service;


    /**
     * Constructor.
     */
    public InteractikCalendarEventViewController() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        // Force menubar contextualization
        request.setAttribute("osivia.cms.menuBar.forceContextualization", true);

        super.view(request, response);

        return "view-interactik";
    }

}
