package fr.toutatice.services.calendar.view.portlet.configuration;

import org.osivia.portal.api.batch.IBatchService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.services.calendar.view.portlet.configuration.CalendarViewConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.portlet.context.PortletContextAware;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;

/**
 * Calendar view portlet configuration.
 *
 * @author Julien Barberet
 * @see CMSPortlet
 * @see PortletContextAware
 */
@Configuration
@ComponentScan(basePackages = {"fr.toutatice.services.calendar.view.portlet", "org.osivia.services.calendar.common"})
public class InteractikCalendarViewConfiguration extends CalendarViewConfiguration {


    /**
     * Constructor.
     */
    public InteractikCalendarViewConfiguration() {
        super();
    }
    
    /**
     * {@inheritDoc}
     */
    @Bean(name = "messageSource")
    @Override
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames("interactik", "Resource");
        return messageSource;
    }

    /**
     * Get batch service
     *
     * @return batch service
     */
    @Bean
    public IBatchService getBatchService() {
        return Locator.findMBean(IBatchService.class, IBatchService.MBEAN_NAME);
    }
}
