package fr.toutatice.services.calendar.view.portlet.model;

import org.osivia.services.calendar.view.portlet.model.CalendarOptions;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/**
 * Interactik calendar options
 * 
 * @author Cédric Krommenhoek
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Primary
public class InteractikCalendarOptions extends CalendarOptions {

    /** Coopérative sélectionnée. */
    private Cooperative selectedCooperative;


    /**
     * Constructor.
     */
    public InteractikCalendarOptions() {
        super();
    }


    /**
     * Getter for selectedCooperative.
     * 
     * @return the selectedCooperative
     */
    public Cooperative getSelectedCooperative() {
        return selectedCooperative;
    }

    /**
     * Setter for selectedCooperative.
     * 
     * @param selectedCooperative the selectedCooperative to set
     */
    public void setSelectedCooperative(Cooperative selectedCooperative) {
        this.selectedCooperative = selectedCooperative;
    }

}
