/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.collab.tools.forum;

import fr.toutatice.ecm.platform.core.constants.PortalConstants;
import fr.toutatice.ecm.platform.web.fragments.PageBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.forum.web.ThreadActionBean;
import org.nuxeo.ecm.webapp.helpers.EventManager;

@Name(value="threadAction")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeThreadActionBean
extends ThreadActionBean {
    private static final long serialVersionUID = 1L;
    protected String firstMessage;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected EventManager eventManager;
    private boolean isModeratedFilled;
    private boolean isSelectedModeratorsFilled;
    @In(create=true)
    protected PageBean pageBean;

    protected DocumentModel getThreadModel() throws ClientException {
        DocumentModel currentChangeableDocument = this.navigationContext.getChangeableDocument();
        this.title = currentChangeableDocument.getTitle();
        this.description = (String)((Object)currentChangeableDocument.getPropertyValue("dc:description"));
        this.firstMessage = (String)((Object)currentChangeableDocument.getPropertyValue("ttcth:message"));
        DocumentModel threadModel = super.getThreadModel();
        threadModel.setPropertyValue("ttcth:message", (Serializable)((Object)this.firstMessage));
        return threadModel;
    }

    public boolean isModerated() {
        if (!this.isModeratedFilled) {
            DocumentModel thread = this.navigationContext.getCurrentDocument();
            try {
                this.moderated = super.isThreadModerated(thread);
                this.isModeratedFilled = true;
            }
            catch (ClientException e) {
                this.moderated = false;
            }
        }
        return this.moderated;
    }

    public List<String> getSelectedModerators() {
        if (!this.isSelectedModeratorsFilled) {
            this.selectedModerators = super.getModerators();
            if (this.selectedModerators == null) {
                this.selectedModerators = new ArrayList();
            }
            this.isSelectedModeratorsFilled = true;
        }
        return this.selectedModerators;
    }

    public String addThread(String viewId) throws ClientException {
        super.addThread();
        this.pageBean.setNotificationKey(PortalConstants.Notifications.SUCCESS_MESSAGE_CREATE_IN_WS.name());
        return viewId;
    }

    public String updateThread() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        currentDocument.setProperty("thread", "moderated", (Object)this.moderated);
        List<String> sM = this.getSelectedModerators();
        if (!this.moderated) {
            sM.clear();
        } else {
            if (!sM.contains("group:administrators")) {
                sM.add("group:administrators");
            }
            if (sM.contains("user:Administrator")) {
                sM.remove("user:Administrator");
            }
        }
        this.setSelectedModerators(sM);
        currentDocument.setProperty("thread", "moderators", (Object)this.selectedModerators);
        Events.instance().raiseEvent("beforeDocumentChanged", new Object[]{currentDocument});
        currentDocument = this.documentManager.saveDocument(currentDocument);
        this.navigationContext.invalidateCurrentDocument();
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("document_modified"), new Object[]{this.resourcesAccessor.getMessages().get(currentDocument.getType())});
        EventManager.raiseEventsOnDocumentChange((DocumentModel)currentDocument);
        return this.navigationContext.navigateToDocument(currentDocument, "after-edit");
    }

    public String updateThread(String viewId) throws ClientException {
        this.updateThread();
        this.pageBean.setNotificationKey(PortalConstants.Notifications.SUCCESS_MESSAGE_MODIFY.name());
        return viewId;
    }

    @Observer(value={"changeableDocumentCreated", "documentSelectionChanged"}, create=false)
    public void refresh() throws ClientException {
        super.clean();
        this.isModeratedFilled = false;
        this.isSelectedModeratorsFilled = false;
    }
}

