/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.RangeFilterBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.range.RangeBuilder;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.AggregateRangeDefinition;
import org.nuxeo.ecm.platform.query.core.BucketRange;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;

public class RangeAggregate
extends AggregateEsBase<BucketRange> {
    public RangeAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @JsonIgnore
    public RangeBuilder getEsAggregate() {
        RangeBuilder ret = (RangeBuilder)AggregationBuilders.range((String)this.getId()).field(this.getField());
        for (AggregateRangeDefinition range : this.getRanges()) {
            if (range.getFrom() != null) {
                if (range.getTo() != null) {
                    ret.addRange(range.getKey(), range.getFrom().doubleValue(), range.getTo().doubleValue());
                    continue;
                }
                ret.addUnboundedFrom(range.getKey(), range.getFrom().doubleValue());
                continue;
            }
            if (range.getTo() == null) continue;
            ret.addUnboundedTo(range.getKey(), range.getTo().doubleValue());
        }
        return ret;
    }

    @JsonIgnore
    public OrFilterBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        OrFilterBuilder ret = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[0]);
        for (AggregateRangeDefinition range : this.getRanges()) {
            if (!this.getSelection().contains(range.getKey())) continue;
            RangeFilterBuilder rangeFilter = FilterBuilders.rangeFilter((String)this.getField());
            if (range.getFrom() != null) {
                rangeFilter.gte((Object)range.getFrom());
            }
            if (range.getTo() != null) {
                rangeFilter.lt((Object)range.getTo());
            }
            ret.add((FilterBuilder)rangeFilter);
        }
        return ret;
    }

    @Override
    @JsonIgnore
    public void parseEsBuckets(Collection<? extends MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<BucketRange> nxBuckets = new ArrayList<BucketRange>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            Range.Bucket rangeBucket = (Range.Bucket)bucket;
            nxBuckets.add(new BucketRange(bucket.getKey(), rangeBucket.getFrom(), rangeBucket.getTo(), rangeBucket.getDocCount()));
        }
        Collections.sort(nxBuckets, new BucketRangeComparator());
        this.buckets = nxBuckets;
    }

    protected class BucketRangeComparator
    implements Comparator<BucketRange> {
        protected BucketRangeComparator() {
        }

        @Override
        public int compare(BucketRange arg0, BucketRange arg1) {
            return ((Integer)RangeAggregate.this.definition.getAggregateRangeDefinitionOrderMap().get(arg0.getKey())).compareTo((Integer)RangeAggregate.this.definition.getAggregateRangeDefinitionOrderMap().get(arg1.getKey()));
        }
    }
}

