/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.loader.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.webengine.loader.store.ResourceStore;

public class FileResourceStore
implements ResourceStore {
    private static final Log log = LogFactory.getLog(FileResourceStore.class);
    protected File root;

    public FileResourceStore(File root) throws IOException {
        this.root = root.getCanonicalFile();
    }

    public File getRoot() {
        return this.root;
    }

    public final File getFile(String name) {
        return new File(this.root, name);
    }

    @Override
    public boolean exists(String name) {
        return this.getFile(name).exists();
    }

    @Override
    public long lastModified(String name) {
        return this.getFile(name).lastModified();
    }

    @Override
    public URL getURL(String name) {
        try {
            File file = this.getFile(name);
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to transform file to URL: " + name), (Throwable)e);
        }
        return null;
    }

    @Override
    public byte[] getBytes(String name) {
        InputStream in = this.getStream(name);
        if (in != null) {
            try {
                return FileUtils.readBytes((InputStream)in);
            }
            catch (IOException e) {
                log.error((Object)("Failed to read file: " + name), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public InputStream getStream(String name) {
        try {
            return new FileInputStream(this.getFile(name));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void remove(String name) {
        this.getFile(name).delete();
    }

    @Override
    public void put(String name, byte[] data) throws IOException {
        FileUtils.writeFile((File)this.getFile(name), (byte[])data);
    }

    @Override
    public void put(String name, InputStream data) throws IOException {
        FileUtils.copyToFile((InputStream)data, (File)this.getFile(name));
    }

    @Override
    public String getLocation() {
        return this.root.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FileResourceStore) {
            FileResourceStore store = (FileResourceStore)obj;
            return store.root.equals(this.root);
        }
        return false;
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public String toString() {
        return "FileResourceStore: " + this.root;
    }
}

