/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.webengine.model.MessagesBundle;
import org.nuxeo.ecm.webengine.model.MessagesProvider;

public class Messages {
    protected final Messages parent;
    protected final MessagesProvider provider;
    protected final Map<String, MessagesBundle> messages;
    protected MessagesBundle defaultMessages;
    protected static final String BUILT_IN_DEFAULT_LANG = "en";

    public Messages(Messages parent, MessagesProvider provider) {
        this.parent = parent;
        this.provider = provider;
        this.messages = new ConcurrentHashMap<String, MessagesBundle>();
        String serverDefaultLang = Locale.getDefault().getLanguage();
        this.defaultMessages = this.getMessagesBundle(serverDefaultLang);
        if (this.defaultMessages == null) {
            this.defaultMessages = new MessagesBundle(null, new HashMap<String, String>());
        }
        if (this.defaultMessages.messages.size() == 0 && !BUILT_IN_DEFAULT_LANG.equals(serverDefaultLang)) {
            this.defaultMessages = this.getMessagesBundle(BUILT_IN_DEFAULT_LANG);
        }
    }

    public MessagesBundle getMessagesBundle() {
        return this.defaultMessages;
    }

    public MessagesBundle getMessagesBundle(String language) {
        if (language == null) {
            return this.defaultMessages;
        }
        MessagesBundle bundle = this.messages.get(language);
        if (bundle == null) {
            Map<String, String> map = this.provider.getMessages(language);
            if (map == null && this.defaultMessages != null) {
                return this.defaultMessages;
            }
            MessagesBundle parentBundle = this.parent != null ? this.parent.getMessagesBundle(language) : null;
            bundle = new MessagesBundle(parentBundle, map);
            this.messages.put(language, bundle);
        }
        return bundle;
    }

    public Object getObject(String key, String language) {
        MessagesBundle bundle = this.getMessagesBundle(language);
        if (bundle != null) {
            return bundle.getObject(key);
        }
        throw new MissingResourceException("Can't find resource for bundle " + this.getClass().getName() + ", key " + key, Messages.class.getName(), key);
    }

    public Object getObject(String key) {
        return this.getObject(key, null);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String language) {
        return (String)this.getObject(key, language);
    }

    public String[] getStringArray(String key) {
        return this.getStringArray(key, null);
    }

    public String[] getStringArray(String key, String language) {
        return (String[])this.getObject(key, language);
    }
}

