/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.Module;
import org.nuxeo.ecm.webengine.scripting.ScriptFile;
import org.nuxeo.runtime.api.Framework;

public class ResourceServlet
extends HttpServlet {
    protected static final Log log = LogFactory.getLog(ResourceServlet.class);
    private static final long serialVersionUID = 6548084847887645044L;
    protected WebEngine engine;

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path;
        if (this.engine == null) {
            try {
                this.engine = (WebEngine)Framework.getService(WebEngine.class);
            }
            catch (Exception e) {
                throw new ServletException("Failed to lookup WebEngine service", (Throwable)e);
            }
        }
        if ((path = req.getPathInfo()) == null) {
            resp.sendError(404);
            return;
        }
        int p = path.indexOf(47, 1);
        String moduleName = null;
        if (p <= -1) {
            resp.sendError(404);
            return;
        }
        moduleName = path.substring(1, p);
        path = path.substring(p);
        Module module = this.engine.getModule(moduleName);
        if (module == null) {
            resp.sendError(404);
            return;
        }
        try {
            this.service(req, resp, module, "/resources" + path);
        }
        catch (Exception e) {
            log.error((Object)("Unable to serve resource for " + path), (Throwable)e);
            resp.sendError(404);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp, Module module, String path) throws IOException {
        ScriptFile file = module.getSkinResource(path);
        if (file != null) {
            long lastModified = file.lastModified();
            resp.setDateHeader("Last-Modified", lastModified);
            resp.addHeader("Cache-Control", "public");
            resp.addHeader("Server", "Nuxeo/WebEngine-1.0");
            String mimeType = this.engine.getMimeType(file.getExtension());
            if (mimeType == null) {
                mimeType = "text/plain";
            }
            resp.setContentType(mimeType);
            if (mimeType.startsWith("text/")) {
                ResourceServlet.sendTextContent(file, resp);
            } else {
                ResourceServlet.sendBinaryContent(file, resp);
            }
            return;
        }
        resp.sendError(404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sendBinaryContent(ScriptFile file, HttpServletResponse resp) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        try (InputStream in = file.getInputStream();){
            FileUtils.copy((InputStream)in, (OutputStream)out);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sendTextContent(ScriptFile file, HttpServletResponse resp) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        try (InputStream in = file.getInputStream();){
            FileUtils.copy((InputStream)in, (OutputStream)out);
        }
        out.flush();
    }
}

