/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUserGroupCodec
extends AbstractDocumentViewCodec {
    public static final String DEFAULT_VIEW_ID = "view_home";
    public static final String ALLOWED_CHARACTERS_REGEX = "nuxeo.codec.usergroup.allowedCharacters";

    public DocumentView getDocumentViewFromUrl(String url, String defaultTab, String paramIdName, String paramShowName) {
        String allowedCharsRegex = Framework.getProperty((String)ALLOWED_CHARACTERS_REGEX, (String)"[a-zA-Z_0-9\\-\\.@]*");
        String userGroupNameRegex = String.format("(%s)?", allowedCharsRegex);
        String url_pattern = "/" + userGroupNameRegex + "(/([a-zA-Z_0-9\\-\\.]*))?/?(\\?((.*)?))?";
        Pattern pattern = Pattern.compile(this.getPrefix() + url_pattern);
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new NuxeoException("Unable to decode the requested url", (Throwable)e);
        }
        Matcher m = pattern.matcher(url);
        if (m.matches() && m.groupCount() >= 1) {
            String query;
            HashMap<String, String> params;
            String id = m.group(1);
            String viewId = m.group(3);
            if (viewId == null || "".equals(viewId)) {
                viewId = DEFAULT_VIEW_ID;
            }
            if ((params = URIUtils.getRequestParameters((String)(query = m.group(5)))) == null) {
                params = new HashMap<String, String>();
            }
            params.put(paramIdName, id);
            params.put(paramShowName, "true");
            if (!params.containsKey("tabIds")) {
                params.put("tabIds", defaultTab);
            }
            DocumentLocationImpl docLoc = new DocumentLocationImpl(this.getDefaultRepositoryName(), null);
            return new DocumentViewImpl((DocumentLocation)docLoc, viewId, params);
        }
        return null;
    }

    public String getUrlFromDocumentViewAndID(DocumentView docView, String paramName) {
        String id = docView.getParameter(paramName);
        if (id != null) {
            docView.removeParameter(paramName);
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            items.add(URIUtils.quoteURIPathComponent((String)id, (boolean)true, (boolean)false));
            String viewId = docView.getViewId();
            if (viewId != null) {
                items.add(viewId);
            }
            String uri = StringUtils.join(items, (String)"/");
            HashMap parameters = docView.getParameters();
            if (parameters == null) {
                parameters = new HashMap();
            }
            return URIUtils.addParametersToURIQuery((String)uri, (Map)parameters);
        }
        return null;
    }

    protected String getDefaultRepositoryName() {
        try {
            return ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepositoryName();
        }
        catch (Exception e) {
            return null;
        }
    }
}

