/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.jwt.automation;

import java.security.Principal;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.runtime.api.Framework;
import org.osivia.jwt.service.JWTTokenService;

@Operation(id="UserGroup.GetJWTToken", category="Users & Groups", label="Gets the authenticated user token", description="Gets the authenticated user token", addToStudio=false)
public class GetJWTToken {
    public static final String ID = "UserGroup.GetJWTToken";
    private JWTTokenService jWTTokenService;
    @Param(name="algorithmId", required=true)
    private String algorithmId;
    @Context
    protected CoreSession coreSession;

    @OperationMethod
    public Blob run() throws ClientException {
        JSONObject jsonResponse = new JSONObject();
        String sessionToken = "";
        Principal principal = this.coreSession.getPrincipal();
        if (principal != null) {
            sessionToken = this.getJWTTokenService().getSessionToken(principal, this.algorithmId);
        }
        jsonResponse.element("token", (Object)sessionToken);
        return new StringBlob(jsonResponse.toString(), "application/json");
    }

    private JWTTokenService getJWTTokenService() {
        if (this.jWTTokenService == null) {
            this.jWTTokenService = (JWTTokenService)Framework.getService(JWTTokenService.class);
        }
        return this.jWTTokenService;
    }
}

