/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.jwt.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osivia.jwt.service.JWTTokenService;
import org.osivia.jwt.service.TokenDescriptor;

public class JWTTokenServiceImpl
extends DefaultComponent
implements JWTTokenService {
    public static final ComponentName ID = new ComponentName("org.osivia.jwt.service.JWTTokenServiceImpl");
    private static final String ALGORITHM_EXTENSION_POINT = "token";
    private static final Log log = LogFactory.getLog(JWTTokenServiceImpl.class);
    private static final int DEFAULT_VALIDITY = 300;
    protected final Map<String, TokenDescriptor> algorithmDescriptors = new HashMap<String, TokenDescriptor>();

    public void deactivate(ComponentContext context) throws Exception {
        this.algorithmDescriptors.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (StringUtils.equals((String)ALGORITHM_EXTENSION_POINT, (String)extensionPoint)) {
            TokenDescriptor algorithmDescriptor = (TokenDescriptor)contribution;
            String algorithmId = algorithmDescriptor.getId();
            this.algorithmDescriptors.put(algorithmId, algorithmDescriptor);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Added descriptor : " + algorithmId));
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (StringUtils.equals((String)ALGORITHM_EXTENSION_POINT, (String)extensionPoint)) {
            TokenDescriptor algorithmDescriptor = (TokenDescriptor)contribution;
            String algorithmId = algorithmDescriptor.getId();
            this.algorithmDescriptors.remove(algorithmId);
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Removed descriptor : " + algorithmId));
            }
        }
    }

    @Override
    public Map<String, Object> getPayload(String token, String algorithmId) {
        TokenDescriptor algorithmDescriptor = this.algorithmDescriptors.get(algorithmId);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        if (algorithmDescriptor != null) {
            DecodedJWT jwt = algorithmDescriptor.getJWTVerifier().verify(token);
            Map claims = jwt.getClaims();
            for (Map.Entry entry : claims.entrySet()) {
                Claim claim = (Claim)entry.getValue();
                String key = (String)entry.getKey();
                if (!claim.isNull() && claim.asMap() != null) {
                    payload.put(key, claim.asMap());
                    continue;
                }
                if (claim.isNull()) continue;
                payload.put(key, claim.as(Object.class));
            }
        }
        return payload;
    }

    @Override
    public String getSignedToken(String payloadObject, String algorithmId) {
        TokenDescriptor algorithmDescriptor = this.algorithmDescriptors.get(algorithmId);
        String signedToken = null;
        if (algorithmDescriptor != null) {
            Algorithm algo = algorithmDescriptor.getAlgorithm();
            LinkedHashMap<String, String> headerClaims = new LinkedHashMap<String, String>();
            headerClaims.put("alg", algo.getName());
            headerClaims.put("typ", "JWT");
            String headerJson = JSONObject.fromObject(headerClaims).toString();
            String header = Base64.encodeBase64URLSafeString((byte[])headerJson.getBytes(StandardCharsets.UTF_8));
            String payload = Base64.encodeBase64URLSafeString((byte[])payloadObject.getBytes(StandardCharsets.UTF_8));
            String content = String.format("%s.%s", header, payload);
            byte[] signatureBytes = algo.sign(content.getBytes(StandardCharsets.UTF_8));
            String signature = Base64.encodeBase64URLSafeString((byte[])signatureBytes);
            signedToken = String.format("%s.%s", content, signature);
        }
        return signedToken;
    }

    @Override
    public String getSessionToken(Principal principal, String algorithmId) {
        TokenDescriptor algorithmDescriptor = this.algorithmDescriptors.get(algorithmId);
        String sessionToken = null;
        if (algorithmDescriptor != null) {
            Calendar cal = GregorianCalendar.getInstance();
            int validity = NumberUtils.toInt((String)algorithmDescriptor.getDuration(), (int)300);
            cal.add(13, validity);
            sessionToken = JWT.create().withIssuedAt(new Date()).withExpiresAt(cal.getTime()).withClaim("userId", principal.getName()).sign(algorithmDescriptor.getAlgorithm());
        }
        return sessionToken;
    }
}

