/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class InputOutput {
    private InputOutput() {
    }

    public static void pump(InputStream input, OutputStream output) throws IOException {
        byte[] bytes = new byte[4096];
        int length = input.read(bytes);
        while (length != -1) {
            output.write(bytes, 0, length);
            length = input.read(bytes);
        }
    }

    public static byte[] pumpToByteArray(InputStream input) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputOutput.pump(input, out);
        return out.toByteArray();
    }

    public static String pumpToString(InputStream input, Charset charset) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputOutput.pump(input, out);
        return out.toString(charset.name());
    }

    public static void pumpToFile(InputStream input, File file) throws IOException {
        FileOutputStream output = new FileOutputStream(file);
        try {
            InputOutput.pump(input, output);
        }
        finally {
            ((OutputStream)output).close();
        }
    }

    public static void pumpFromFile(File file, OutputStream output) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            InputOutput.pump(in, output);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(File source, File target) throws IOException {
        FileOutputStream fos = new FileOutputStream(target);
        ZipOutputStream zos = new ZipOutputStream(fos);
        try {
            ZipEntry ze = new ZipEntry(source.getName());
            zos.putNextEntry(ze);
            InputOutput.pumpFromFile(source, zos);
            zos.closeEntry();
        }
        finally {
            zos.close();
        }
    }

    public static boolean deleteFile(File file) {
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File target) throws IOException {
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        try {
            InputOutput.pump(in, out);
        }
        finally {
            out.close();
            in.close();
        }
    }
}

