/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bull.javamelody.internal.model.CounterRequestRumData;

public class CounterRequest
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -4301825473892026959L;
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private final String name;
    private final String id;
    private long hits;
    private long durationsSum;
    private long durationsSquareSum;
    private long maximum;
    private long cpuTimeSum;
    private long allocatedKBytesSum;
    private long systemErrors;
    private long responseSizesSum;
    private long childHits;
    private long childDurationsSum;
    private String stackTrace;
    private Map<String, Long> childRequestsExecutionsByRequestId;
    private CounterRequestRumData rumData;

    public CounterRequest(String name, String counterName) {
        assert (name != null);
        assert (counterName != null);
        this.name = name;
        this.id = CounterRequest.buildId(name, counterName);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public long getHits() {
        return this.hits;
    }

    public long getSystemErrors() {
        return this.systemErrors;
    }

    public long getDurationsSum() {
        return this.durationsSum;
    }

    public int getMean() {
        if (this.hits > 0L) {
            return (int)(this.durationsSum / this.hits);
        }
        return -1;
    }

    public int getStandardDeviation() {
        if (this.hits > 0L) {
            return (int)Math.sqrt(((double)this.durationsSquareSum - (double)this.durationsSum * (double)this.durationsSum / (double)this.hits) / (double)(this.hits - 1L));
        }
        return -1;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public long getCpuTimeSum() {
        return this.cpuTimeSum;
    }

    public int getCpuTimeMean() {
        if (this.hits > 0L) {
            return (int)(this.cpuTimeSum / this.hits);
        }
        return -1;
    }

    public int getAllocatedKBytesMean() {
        if (this.hits > 0L && this.allocatedKBytesSum >= 0L) {
            return (int)(this.allocatedKBytesSum / this.hits);
        }
        return -1;
    }

    public float getSystemErrorPercentage() {
        if (this.hits > 0L) {
            return Math.min(100.0f * (float)this.systemErrors / (float)this.hits, 100.0f);
        }
        return 0.0f;
    }

    public long getResponseSizeMean() {
        if (this.hits > 0L) {
            return this.responseSizesSum / this.hits;
        }
        return -1L;
    }

    public boolean hasChildHits() {
        return this.childHits > 0L;
    }

    public int getChildHitsMean() {
        if (this.hits > 0L) {
            return (int)(this.childHits / this.hits);
        }
        return -1;
    }

    public int getChildDurationsMean() {
        if (this.hits > 0L) {
            return (int)(this.childDurationsSum / this.hits);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getChildRequestsExecutionsByRequestId() {
        if (this.childRequestsExecutionsByRequestId == null) {
            return Collections.emptyMap();
        }
        CounterRequest counterRequest = this;
        synchronized (counterRequest) {
            return new LinkedHashMap<String, Long>(this.childRequestsExecutionsByRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsChildRequest(String requestId) {
        if (this.childRequestsExecutionsByRequestId == null) {
            return false;
        }
        CounterRequest counterRequest = this;
        synchronized (counterRequest) {
            return this.childRequestsExecutionsByRequestId.containsKey(requestId);
        }
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public CounterRequestRumData getRumData() {
        return this.rumData;
    }

    void addHit(long duration, int cpuTime, int allocatedKBytes, boolean systemError, String systemErrorStackTrace, long responseSize) {
        ++this.hits;
        this.durationsSum += duration;
        this.durationsSquareSum += duration * duration;
        if (duration > this.maximum) {
            this.maximum = duration;
        }
        this.cpuTimeSum += (long)cpuTime;
        this.allocatedKBytesSum += (long)allocatedKBytes;
        if (systemError) {
            ++this.systemErrors;
        }
        if (systemErrorStackTrace != null) {
            this.stackTrace = systemErrorStackTrace;
        }
        this.responseSizesSum += responseSize;
    }

    void addChildHits(ICounterRequestContext context) {
        this.childHits += (long)context.getChildHits();
        this.childDurationsSum += (long)context.getChildDurationsSum();
    }

    void addChildRequests(Map<String, Long> childRequests) {
        if (childRequests != null && !childRequests.isEmpty()) {
            if (this.childRequestsExecutionsByRequestId == null) {
                this.childRequestsExecutionsByRequestId = new LinkedHashMap<String, Long>(childRequests);
            } else {
                for (Map.Entry<String, Long> entry : childRequests.entrySet()) {
                    String requestId = entry.getKey();
                    Long nbExecutions = this.childRequestsExecutionsByRequestId.get(requestId);
                    if (nbExecutions == null) {
                        if (this.childRequestsExecutionsByRequestId.size() >= 10000) continue;
                        nbExecutions = entry.getValue();
                    } else {
                        nbExecutions = nbExecutions + entry.getValue();
                    }
                    this.childRequestsExecutionsByRequestId.put(requestId, nbExecutions);
                }
            }
        }
    }

    void addHits(CounterRequest request) {
        assert (request != null);
        if (request.hits != 0L) {
            this.hits += request.hits;
            this.durationsSum += request.durationsSum;
            this.durationsSquareSum += request.durationsSquareSum;
            if (request.maximum > this.maximum) {
                this.maximum = request.maximum;
            }
            this.cpuTimeSum += request.cpuTimeSum;
            this.allocatedKBytesSum += request.allocatedKBytesSum;
            this.systemErrors += request.systemErrors;
            this.responseSizesSum += request.responseSizesSum;
            this.childHits += request.childHits;
            this.childDurationsSum += request.childDurationsSum;
            if (request.stackTrace != null) {
                this.stackTrace = request.stackTrace;
            }
            this.addChildRequests(request.childRequestsExecutionsByRequestId);
        }
        if (request.rumData != null) {
            if (this.rumData != null) {
                this.rumData.addHits(request.rumData);
            } else {
                this.rumData = request.rumData.clone();
            }
        }
    }

    void removeHits(CounterRequest request) {
        assert (request != null);
        if (request.hits != 0L) {
            this.hits -= request.hits;
            this.durationsSum -= request.durationsSum;
            this.durationsSquareSum -= request.durationsSquareSum;
            if (request.maximum >= this.maximum) {
                this.maximum = this.hits > 0L ? this.durationsSum / this.hits : -1L;
            }
            this.cpuTimeSum -= request.cpuTimeSum;
            this.allocatedKBytesSum -= request.allocatedKBytesSum;
            this.systemErrors -= request.systemErrors;
            this.responseSizesSum -= request.responseSizesSum;
            this.childHits -= request.childHits;
            this.childDurationsSum -= request.childDurationsSum;
            this.removeChildHits(request);
        }
        if (this.rumData != null && request.rumData != null) {
            this.rumData.removeHits(request.rumData);
        }
    }

    private void removeChildHits(CounterRequest request) {
        if (request.childRequestsExecutionsByRequestId != null && this.childRequestsExecutionsByRequestId != null) {
            for (Map.Entry<String, Long> entry : request.childRequestsExecutionsByRequestId.entrySet()) {
                String requestId = entry.getKey();
                Long nbExecutions = this.childRequestsExecutionsByRequestId.get(requestId);
                if (nbExecutions == null) continue;
                if ((nbExecutions = Long.valueOf(Math.max(nbExecutions - entry.getValue(), 0L))) == 0L) {
                    this.childRequestsExecutionsByRequestId.remove(requestId);
                    if (!this.childRequestsExecutionsByRequestId.isEmpty()) continue;
                    this.childRequestsExecutionsByRequestId = null;
                    break;
                }
                this.childRequestsExecutionsByRequestId.put(requestId, nbExecutions);
            }
        }
    }

    void addRumHit(long networkTime, long domProcessing, long pageRendering) {
        if (this.rumData == null) {
            this.rumData = new CounterRequestRumData();
        }
        this.rumData.addHit(networkTime, domProcessing, pageRendering);
    }

    public CounterRequest clone() {
        try {
            CounterRequest clone = (CounterRequest)super.clone();
            if (this.childRequestsExecutionsByRequestId != null) {
                clone.childRequestsExecutionsByRequestId = this.getChildRequestsExecutionsByRequestId();
            }
            if (this.rumData != null) {
                clone.rumData = this.rumData.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String buildId(String name, String counterName) {
        MessageDigest messageDigest = CounterRequest.getMessageDigestInstance();
        messageDigest.update(name.getBytes());
        byte[] digest = messageDigest.digest();
        int l = counterName.length();
        char[] chars = new char[l + digest.length * 2];
        counterName.getChars(0, l, chars, 0);
        for (int j = 0; j < digest.length; ++j) {
            int v = digest[j] & 0xFF;
            chars[j * 2 + l] = HEX_ARRAY[v >>> 4];
            chars[j * 2 + 1 + l] = HEX_ARRAY[v & 0xF];
        }
        return new String(chars);
    }

    private static MessageDigest getMessageDigestInstance() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", hits=" + this.getHits() + ", id=" + this.getId() + ']';
    }

    static interface ICounterRequestContext {
        public int getChildHits();

        public int getChildDurationsSum();
    }
}

