/*
 * Decompiled with CFR 0.152.
 */
package org.etherpad_lite_client;

import java.util.Date;
import java.util.HashMap;
import org.etherpad_lite_client.EPLiteConnection;

public class EPLiteClient {
    public static final String DEFAULT_API_VERSION = "1.2.1";
    public EPLiteConnection connection;

    public EPLiteClient(String url, String apiKey) {
        this.connection = new EPLiteConnection(url, apiKey, DEFAULT_API_VERSION);
    }

    public EPLiteClient(String url, String apiKey, String apiVersion) {
        this.connection = new EPLiteConnection(url, apiKey, apiVersion);
    }

    public HashMap createGroup() {
        return this.connection.post("createGroup");
    }

    public HashMap createGroupIfNotExistsFor(String groupMapper) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("groupMapper", groupMapper);
        return this.connection.post("createGroupIfNotExistsFor", args);
    }

    public void deleteGroup(String groupID) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("groupID", groupID);
        this.connection.post("deleteGroup", args);
    }

    public HashMap listPads(String groupID) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("groupID", groupID);
        return this.connection.get("listPads", args);
    }

    public HashMap createGroupPad(String groupID, String padName) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("groupID", groupID);
        args.put("padName", padName);
        return this.connection.post("createGroupPad", args);
    }

    public void createGroupPad(String groupID, String padName, String text) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("groupID", groupID);
        args.put("padName", padName);
        args.put("text", text);
        this.connection.post("createGroupPad", args);
    }

    public HashMap listAllGroups() {
        return this.connection.get("listAllGroups");
    }

    public HashMap createAuthor() {
        return this.connection.post("createAuthor");
    }

    public HashMap createAuthor(String name) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("name", name);
        return this.connection.post("createAuthor", args);
    }

    public HashMap createAuthorIfNotExistsFor(String authorMapper) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("authorMapper", authorMapper);
        return this.connection.post("createAuthorIfNotExistsFor", args);
    }

    public HashMap createAuthorIfNotExistsFor(String authorMapper, String name) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("authorMapper", authorMapper);
        args.put("name", name);
        return this.connection.post("createAuthorIfNotExistsFor", args);
    }

    public HashMap listPadsOfAuthor(String authorId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("authorID", authorId);
        return this.connection.get("listPadsOfAuthor", args);
    }

    public String getAuthorName(String authorId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("authorID", authorId);
        return this.connection.get("getAuthorName", args).toString();
    }

    public HashMap createSession(String groupID, String authorID, long validUntil) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("groupID", groupID);
        args.put("authorID", authorID);
        args.put("validUntil", String.valueOf(validUntil));
        return this.connection.post("createSession", args);
    }

    public HashMap createSession(String groupID, String authorID, int length) {
        long inNHours = (new Date().getTime() + (long)length * 60L * 60L * 1000L) / 1000L;
        return this.createSession(groupID, authorID, inNHours);
    }

    public HashMap createSession(String groupID, String authorID, Date validUntil) {
        long seconds = validUntil.getTime() / 1000L;
        return this.createSession(groupID, authorID, seconds);
    }

    public void deleteSession(String sessionID) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("sessionID", sessionID);
        this.connection.post("deleteSession", args);
    }

    public HashMap getSessionInfo(String sessionID) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("sessionID", sessionID);
        return this.connection.get("getSessionInfo", args);
    }

    public HashMap listSessionsOfGroup(String groupID) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("groupID", groupID);
        return this.connection.get("listSessionsOfGroup", args);
    }

    public HashMap listSessionsOfAuthor(String authorID) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("authorID", authorID);
        return this.connection.get("listSessionsOfAuthor", args);
    }

    public HashMap listAllPads() {
        return this.connection.get("listAllPads");
    }

    public HashMap getText(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        return this.connection.get("getText", args);
    }

    public HashMap getText(String padId, int rev) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("rev", new Integer(rev));
        return this.connection.get("getText", args);
    }

    public void setText(String padId, String text) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        args.put("text", text);
        this.connection.post("setText", args);
    }

    public HashMap getHTML(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        return this.connection.get("getHTML", args);
    }

    public HashMap getHTML(String padId, int rev) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("rev", new Integer(rev));
        return this.connection.get("getHTML", args);
    }

    public void setHTML(String padId, String html) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        args.put("html", html);
        this.connection.post("setHTML", args);
    }

    public void createPad(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        this.connection.post("createPad", args);
    }

    public void createPad(String padId, String text) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        args.put("text", text);
        this.connection.post("createPad", args);
    }

    public HashMap getRevisionsCount(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        return this.connection.get("getRevisionsCount", args);
    }

    public HashMap listAuthorsOfPad(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        return this.connection.get("listAuthorsOfPad", args);
    }

    public void deletePad(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        this.connection.post("deletePad", args);
    }

    public HashMap getReadOnlyID(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        return this.connection.get("getReadOnlyID", args);
    }

    public HashMap getLastEdited(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        return this.connection.get("getLastEdited", args);
    }

    public Long padUsersCount(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        Long userCount = (Long)this.connection.get("padUsersCount", args).get("padUsersCount");
        return userCount;
    }

    public HashMap padUsers(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        return this.connection.get("padUsers", args);
    }

    public void setPublicStatus(String padId, Boolean publicStatus) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("padID", padId);
        args.put("publicStatus", publicStatus);
        this.connection.post("setPublicStatus", args);
    }

    public HashMap getPublicStatus(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        return this.connection.get("getPublicStatus", args);
    }

    public void setPassword(String padId, String password) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        args.put("password", password);
        this.connection.post("setPassword", args);
    }

    public HashMap isPasswordProtected(String padId) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        return this.connection.get("isPasswordProtected", args);
    }

    public void sendClientsMessage(String padId, String msg) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("padID", padId);
        args.put("msg", msg);
        this.connection.post("sendClientsMessage", args);
    }

    public boolean isSecure() {
        return this.connection.uri.getPort() == 443;
    }
}

