/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.local;

import java.security.Principal;
import java.util.LinkedList;
import javax.security.auth.Subject;

public class LoginStack {
    protected final LinkedList<Entry> stack = new LinkedList();

    public static LoginStack synchronizedStack() {
        return new Sync();
    }

    public void clear() {
        this.stack.clear();
    }

    public void push(Principal principal, Object credential, Subject subject) {
        this.stack.add(new Entry(principal, credential, subject));
    }

    public Entry pop() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.removeLast();
    }

    public Entry peek() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.getLast();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int size() {
        return this.stack.size();
    }

    public Entry get(int index) {
        return this.stack.get(index);
    }

    public Entry remove(int index) {
        return this.stack.remove(index);
    }

    public Entry[] toArray() {
        return this.stack.toArray(new Entry[this.stack.size()]);
    }

    public static class Sync
    extends LoginStack {
        @Override
        public synchronized void clear() {
            this.stack.clear();
        }

        @Override
        public synchronized void push(Principal principal, Object credential, Subject subject) {
            this.stack.add(new Entry(principal, credential, subject));
        }

        @Override
        public synchronized Entry pop() {
            if (this.stack.isEmpty()) {
                return null;
            }
            return (Entry)this.stack.removeLast();
        }

        @Override
        public synchronized Entry peek() {
            if (this.stack.isEmpty()) {
                return null;
            }
            return (Entry)this.stack.getLast();
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.stack.isEmpty();
        }

        @Override
        public synchronized int size() {
            return this.stack.size();
        }

        @Override
        public synchronized Entry get(int index) {
            return (Entry)this.stack.get(index);
        }

        @Override
        public synchronized Entry remove(int index) {
            return (Entry)this.stack.remove(index);
        }

        @Override
        public synchronized Entry[] toArray() {
            return this.stack.toArray(new Entry[this.stack.size()]);
        }
    }

    public static class Entry {
        protected final Principal principal;
        protected final Object credential;
        protected final Subject subject;

        public Entry(Principal principal, Object credential, Subject subject) {
            this.principal = principal;
            this.credential = credential;
            this.subject = subject;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public Object getCredential() {
            return this.credential;
        }

        public Subject getSubject() {
            return this.subject;
        }
    }
}

