/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.security.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;

public class ACLImpl
extends ArrayList<ACE>
implements ACL {
    private static final long serialVersionUID = 5332101749929771434L;
    private static final Log log = LogFactory.getLog(ACLImpl.class);
    private final String name;
    private final boolean isReadOnly;

    public ACLImpl(String name, boolean isReadOnly) {
        this.name = name;
        this.isReadOnly = isReadOnly;
    }

    public ACLImpl() {
        this("local", false);
    }

    public ACLImpl(String name) {
        this(name, false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ACE[] getACEs() {
        return this.toArray(new ACE[this.size()]);
    }

    @Override
    public void setACEs(ACE[] aces) {
        this.clear();
        this.addAll(Arrays.asList(aces));
        this.warnForDuplicateACEs(aces);
    }

    private void warnForDuplicateACEs(ACE[] aces) {
        if (!log.isWarnEnabled() || "inherited".equals(this.name)) {
            return;
        }
        HashSet<ACE> aceSet = new HashSet<ACE>(aces.length);
        for (ACE ace : aces) {
            if (aceSet.add(ace)) continue;
            Throwable throwable = null;
            if (log.isTraceEnabled()) {
                throwable = new Throwable();
            }
            log.warn((Object)("Setting an ACL with at least one duplicate entry: " + ace + ", ACL entries: " + Arrays.toString(aces)), throwable);
            break;
        }
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public Object clone() {
        ACLImpl copy = new ACLImpl(this.name, this.isReadOnly);
        ACE[] aces = new ACE[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            aces[i] = (ACE)((ACE)this.get(i)).clone();
        }
        copy.setACEs(aces);
        return copy;
    }
}

