/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap.dns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.ldap.dns.DNSServiceEntry;
import org.nuxeo.ecm.directory.ldap.dns.DNSServiceResolver;
import org.nuxeo.runtime.api.Framework;

public class DNSServiceResolverImpl
implements DNSServiceResolver {
    public static final Log log = LogFactory.getLog(DNSServiceResolverImpl.class);
    protected static DNSServiceResolver instance;
    protected static final String SRV_RECORD = "SRV";
    protected Map<String, List<DNSServiceEntry>> cache = new HashMap<String, List<DNSServiceEntry>>();
    protected long lastCacheUpdate = System.currentTimeMillis();
    protected final long maxDelay;
    protected static DirContext context;

    public static synchronized DNSServiceResolver getInstance() {
        if (instance == null) {
            instance = new DNSServiceResolverImpl();
        }
        return instance;
    }

    protected DNSServiceResolverImpl() {
        int cacheExpiry = 10;
        try {
            cacheExpiry = Integer.parseInt(Framework.getProperty((String)"org.nuxeo.ecm.directory.ldap.dns.cache.expiry", (String)"10"));
        }
        catch (NumberFormatException e) {
            log.warn((Object)"invalid value for property: org.nuxeo.ecm.directory.ldap.dns.cache.expiry, falling back to default value of 10 minutes");
        }
        this.maxDelay = 60000 * cacheExpiry;
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            context = new InitialDirContext(env);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<DNSServiceEntry> resolveDnsServiceRecord(String service, String domain) throws NamingException {
        List<DNSServiceEntry> addresses = new ArrayList<DNSServiceEntry>();
        if (context == null) {
            return addresses;
        }
        String key = service + "." + domain;
        if (System.currentTimeMillis() - this.lastCacheUpdate > this.maxDelay) {
            this.cache.clear();
        }
        if (this.cache.containsKey(key) && (addresses = this.cache.get(key)) != null) {
            return addresses;
        }
        Attributes dnsLookup = context.getAttributes(service + "." + domain, new String[]{SRV_RECORD});
        Attribute attribute = dnsLookup.get(SRV_RECORD);
        for (int i = 0; i < attribute.size(); ++i) {
            String entry = (String)attribute.get(i);
            String[] records = entry.split(" ");
            String host = records[records.length - 1];
            int port = Integer.parseInt(records[records.length - 2]);
            int weight = Integer.parseInt(records[records.length - 3]);
            int priority = Integer.parseInt(records[records.length - 4]);
            if (host.endsWith(".")) {
                host = host.substring(0, host.length() - 1);
            }
            addresses.add(new DNSServiceEntry(host, port, priority, weight));
        }
        Collections.sort(addresses);
        if (this.cache.size() > 100) {
            this.cache.clear();
        }
        this.cache.put(key, addresses);
        this.lastCacheUpdate = System.currentTimeMillis();
        return addresses;
    }

    @Override
    public List<DNSServiceEntry> resolveLDAPDomainServers(String domain) throws NamingException {
        return this.resolveDnsServiceRecord("_ldap._tcp", domain);
    }

    @Override
    public List<DNSServiceEntry> resolveLDAPDomainServers(String domain, String prefix) throws NamingException {
        return this.resolveDnsServiceRecord(prefix, domain);
    }
}

