/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPDirectoryDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class LDAPDirectoryRegistry
extends ContributionFragmentRegistry<LDAPDirectoryDescriptor> {
    private static final Log log = LogFactory.getLog(LDAPDirectoryRegistry.class);
    private final Map<String, Directory> proxies = new HashMap<String, Directory>();

    public String getContributionId(LDAPDirectoryDescriptor contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, LDAPDirectoryDescriptor descriptor, LDAPDirectoryDescriptor newOrigContrib) {
        String descriptorName = descriptor.getName();
        this.proxies.put(descriptorName, (Directory)new LDAPDirectory(descriptor));
        log.info((Object)("directory registered: " + descriptorName));
    }

    public void contributionRemoved(String id, LDAPDirectoryDescriptor descriptor) {
        String directoryName = descriptor.getName();
        Directory dir = this.proxies.remove(directoryName);
        if (dir != null) {
            try {
                dir.shutdown();
            }
            catch (DirectoryException e) {
                log.error((Object)String.format("Error while shutting down directory '%s'", id), (Throwable)e);
            }
        }
        log.info((Object)("directory unregistered: " + directoryName));
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public LDAPDirectoryDescriptor clone(LDAPDirectoryDescriptor orig) {
        throw new UnsupportedOperationException();
    }

    public void merge(LDAPDirectoryDescriptor src, LDAPDirectoryDescriptor dst) {
        throw new UnsupportedOperationException();
    }

    public Directory getDirectory(String name) {
        return this.proxies.get(name);
    }

    public List<Directory> getDirectories() {
        ArrayList<Directory> res = new ArrayList<Directory>();
        res.addAll(this.proxies.values());
        return res;
    }
}

