/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;

@Name(value="mainTabsActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class MainTabsActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final String MAIN_TABS_CATEGORY = "MAIN_TABS";
    @Deprecated
    public static final String DOCUMENT_MANAGEMENT_ACTION = "documents";
    @Deprecated
    public static final String TAB_IDS_PARAMETER = "tabIds";
    @Deprecated
    public static final String MAIN_TAB_ID_PARAMETER = "mainTabId";
    public static final String DEFAULT_VIEW = "view_documents";
    @In(create=true)
    protected transient RepositoryManager repositoryManager;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true, required=false)
    protected transient ActionManager actionManager;
    protected Map<String, DocumentModel> documentsByMainTabs = new HashMap<String, DocumentModel>();

    @Observer(value={"navigateToDocument"})
    public void updateContextualDocument() {
        if (!this.shouldHandleRequest()) {
            return;
        }
        String currentMainTab = this.getCurrentMainTabFromRequest();
        if (currentMainTab == null) {
            currentMainTab = this.webActions.getCurrentTabId(MAIN_TABS_CATEGORY);
        }
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.documentsByMainTabs.put(currentMainTab, currentDocument);
    }

    protected boolean shouldHandleRequest() {
        ServletRequest request = (ServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            return !httpServletRequest.getMethod().equalsIgnoreCase("post");
        }
        return false;
    }

    protected String getCurrentMainTabFromRequest() {
        try {
            URLPolicyService service = (URLPolicyService)Framework.getService(URLPolicyService.class);
            ServletRequest request = (ServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
            if (request instanceof HttpServletRequest) {
                DocumentView docView = service.getDocumentViewFromRequest((HttpServletRequest)request);
                if (docView == null) {
                    return null;
                }
                String tabIds = docView.getParameter(TAB_IDS_PARAMETER);
                String mainTabId = docView.getParameter(MAIN_TAB_ID_PARAMETER);
                if (mainTabId != null && !mainTabId.isEmpty()) {
                    tabIds = mainTabId;
                }
                if (tabIds != null && tabIds.contains(MAIN_TABS_CATEGORY)) {
                    String[] encodedActions;
                    for (String encodedAction : encodedActions = tabIds.split(",")) {
                        String[] actionInfo;
                        if (!encodedAction.startsWith(MAIN_TABS_CATEGORY) || (actionInfo = encodedAction.split(":")) == null || actionInfo.length <= 1) continue;
                        return actionInfo[1];
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setDocumentFor(String mainTabId, DocumentModel doc) {
        this.documentsByMainTabs.put(mainTabId, doc);
    }

    public DocumentModel getDocumentFor(String mainTabId) throws ClientException {
        return this.getDocumentFor(mainTabId, this.navigationContext.getCurrentDocument());
    }

    public DocumentModel getDocumentFor(String mainTabId, DocumentModel defaultDocument) throws ClientException {
        DocumentModel doc = this.documentsByMainTabs.get(mainTabId);
        if (doc == null || !this.documentManager.exists(doc.getRef()) || !this.documentManager.hasPermission(doc.getRef(), "Read")) {
            this.documentsByMainTabs.put(mainTabId, defaultDocument);
            doc = null;
        }
        if (doc != null && !this.documentManager.exists((DocumentRef)new PathRef(doc.getPathAsString()))) {
            doc = this.documentManager.getDocument(doc.getRef());
            this.documentsByMainTabs.put(mainTabId, doc);
        }
        return doc != null ? doc : defaultDocument;
    }

    public String getViewFor(Action mainTabAction) throws ClientException {
        if (!mainTabAction.getId().equals(DOCUMENT_MANAGEMENT_ACTION)) {
            return mainTabAction.getLink();
        }
        DocumentModel doc = this.getDocumentFor(mainTabAction.getId(), this.navigationContext.getCurrentDocument());
        if (doc != null) {
            TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
            return typeInfo.getDefaultView();
        }
        return DEFAULT_VIEW;
    }

    public String getViewFor(String mainTabId) throws ClientException {
        Action mainTabAction = this.actionManager.getAction(mainTabId);
        return mainTabAction != null ? this.getViewFor(mainTabAction) : null;
    }

    public String getPatternFor(String mainTabId) throws ClientException {
        try {
            URLPolicyService service = (URLPolicyService)Framework.getService(URLPolicyService.class);
            if (!DOCUMENT_MANAGEMENT_ACTION.equals(mainTabId) && service.hasPattern(mainTabId)) {
                return mainTabId;
            }
            return service.getDefaultPatternName();
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    public boolean isOnMainTab(String mainTabId) {
        return mainTabId != null && mainTabId.equals(this.webActions.getCurrentTabId(MAIN_TABS_CATEGORY));
    }
}

