/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

@Name(value="docSuggestionActions")
@Scope(value=ScopeType.PAGE)
public class DocumentSuggestionActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_PAGE_PROVIDER_NAME = "default_document_suggestion";
    @In(required=true)
    protected transient CoreSession documentManager;
    @RequestParameter
    protected String pageProviderName;
    @RequestParameter
    protected Boolean prefixSearch;
    protected String cachedPageProviderName;
    protected Object cachedInput;
    protected List<DocumentModel> cachedSuggestions;

    public List<DocumentModel> getDocSuggestions(Object input) throws ClientException {
        if (this.equals(this.cachedPageProviderName, this.pageProviderName) && this.equals(this.cachedInput, input)) {
            return this.cachedSuggestions;
        }
        String pattern = (String)input;
        PageProvider<DocumentModel> pp = this.getPageProvider(pattern);
        List documents = pp.getCurrentPage();
        this.cachedInput = input;
        this.cachedSuggestions = documents;
        return documents;
    }

    protected PageProvider<DocumentModel> getPageProvider(String pattern) throws ClientException {
        String ppName = DEFAULT_PAGE_PROVIDER_NAME;
        if (this.pageProviderName != null && !StringUtils.isEmpty((String)this.pageProviderName)) {
            ppName = this.pageProviderName;
        }
        try {
            PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
            HashMap<String, Serializable> props = new HashMap<String, Serializable>();
            props.put("coreSession", (Serializable)this.documentManager);
            PageProviderDefinition ppDef = ppService.getPageProviderDefinition(ppName);
            String[] params = ppDef.getQueryParameters();
            if (params == null) {
                params = new String[]{};
            }
            FacesContext context = FacesContext.getCurrentInstance();
            Object[] resolvedParams = new Object[params.length + 1];
            if (Boolean.TRUE.equals(this.prefixSearch) && !pattern.endsWith(" ")) {
                pattern = pattern + "*";
            }
            resolvedParams[0] = pattern;
            for (int i = 0; i < params.length; ++i) {
                resolvedParams[i + 1] = ComponentTagUtils.resolveElExpression((FacesContext)context, (String)params[i]);
            }
            PageProvider pp = ppService.getPageProvider(ppName, null, null, null, props, resolvedParams);
            if (pp == null) {
                throw new ClientException("Page provider not found: " + ppName);
            }
            return pp;
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Error searching for documents", (Throwable)e);
        }
    }

    public boolean getDocumentExistsAndIsVisibleWithId(String id) throws ClientException {
        if (StringUtils.isEmpty((String)id)) {
            return false;
        }
        IdRef ref = new IdRef(id);
        return this.documentManager.exists((DocumentRef)ref) && this.documentManager.hasPermission((DocumentRef)ref, "Read");
    }

    public boolean getDocumentExistsAndIsVisibleWithPath(String path) throws ClientException {
        if (StringUtils.isEmpty((String)path)) {
            return false;
        }
        PathRef ref = new PathRef(path);
        return this.documentManager.exists((DocumentRef)ref) && this.documentManager.hasPermission((DocumentRef)ref, "Read");
    }

    public DocumentModel getDocumentWithId(String id) throws ClientException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return this.documentManager.getDocument((DocumentRef)new IdRef(id));
    }

    public DocumentModel getDocumentWithPath(String path) throws ClientException {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        return this.documentManager.getDocument((DocumentRef)new PathRef(path));
    }

    protected boolean equals(Object item1, Object item2) {
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null) {
            return false;
        }
        return item1.equals(item2);
    }
}

