/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.publisher;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.core.RootSectionsPublicationTree;

public class RenditionPublicationCoreTree
extends RootSectionsPublicationTree {
    private static final long serialVersionUID = 1L;
    public static final String RENDITION_PUBLISHED_DOCUMENTS_FROM_PROXY_DOCUMENT = "SELECT * FROM Document WHERE rend:sourceId = '%s' AND ecm:path STARTSWITH '%s' AND ecm:isProxy = 1";
    public static final String RENDITION_PUBLISHED_DOCUMENTS_FROM_LIVE_DOCUMENT = "SELECT * FROM Document WHERE rend:sourceVersionableId = '%s' AND ecm:path STARTSWITH '%s' AND ecm:isProxy = 1";

    public List<PublishedDocument> getExistingPublishedDocument(DocumentLocation docLoc) throws ClientException {
        List publishedDocuments = super.getExistingPublishedDocument(docLoc);
        DocumentModel sourceDocument = this.coreSession.getDocument(docLoc.getDocRef());
        if (sourceDocument.isProxy()) {
            if (!sourceDocument.hasFacet("Rendition") && !sourceDocument.hasSchema("rendition")) {
                return publishedDocuments;
            }
            IdRef docRef = new IdRef((String)((Object)sourceDocument.getPropertyValue("rend:sourceId")));
            publishedDocuments.addAll(this.getPublishedDocumentsFromProxyDocument((DocumentRef)docRef, sourceDocument));
        } else {
            publishedDocuments.addAll(this.getPublishedDocumentsFromLiveDocument(docLoc.getDocRef()));
        }
        return publishedDocuments;
    }

    protected List<PublishedDocument> getPublishedDocumentsFromProxyDocument(DocumentRef docRef, DocumentModel sourceDocument) throws ClientException {
        ArrayList<PublishedDocument> publishedDocuments = new ArrayList<PublishedDocument>();
        DocumentModelList docs = this.coreSession.query(String.format(RENDITION_PUBLISHED_DOCUMENTS_FROM_PROXY_DOCUMENT, docRef, NXQL.escapeStringInner((String)this.rootPath)));
        for (DocumentModel doc : docs) {
            if (doc.getRef().equals(sourceDocument.getRef())) continue;
            publishedDocuments.add(this.factory.wrapDocumentModel(doc));
        }
        return publishedDocuments;
    }

    protected List<PublishedDocument> getPublishedDocumentsFromLiveDocument(DocumentRef docRef) throws ClientException {
        ArrayList<PublishedDocument> publishedDocuments = new ArrayList<PublishedDocument>();
        DocumentModelList docs = this.coreSession.query(String.format(RENDITION_PUBLISHED_DOCUMENTS_FROM_LIVE_DOCUMENT, docRef, NXQL.escapeStringInner((String)this.rootPath)));
        for (DocumentModel doc : docs) {
            publishedDocuments.add(this.factory.wrapDocumentModel(doc));
        }
        return publishedDocuments;
    }
}

