/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema;

import java.util.Comparator;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.name.LdapDN;

public class DnComparator
implements Comparator {
    private AttributeTypeRegistry attrRegistry;

    public DnComparator(AttributeTypeRegistry attrRegistry) {
        this.attrRegistry = attrRegistry;
    }

    public DnComparator() {
    }

    public void setRegistries(Registries registries) {
        this.attrRegistry = registries.getAttributeTypeRegistry();
    }

    public int compare(Object obj0, Object obj1) {
        LdapDN dn0 = null;
        LdapDN dn1 = null;
        try {
            dn0 = this.getDn(obj0);
            dn1 = this.getDn(obj1);
        }
        catch (NamingException e) {
            return -1;
        }
        return dn0.compareTo((Object)dn1);
    }

    public LdapDN getDn(Object obj) throws NamingException {
        LdapDN dn = null;
        if (obj instanceof LdapDN) {
            dn = (LdapDN)obj;
            dn = dn.isNormalized() ? dn : LdapDN.normalize((LdapDN)dn, this.attrRegistry.getNormalizerMapping());
        } else if (obj instanceof Name) {
            dn = new LdapDN((Name)obj);
            dn.normalize(this.attrRegistry.getNormalizerMapping());
        } else if (obj instanceof String) {
            dn = new LdapDN((String)obj);
            dn.normalize(this.attrRegistry.getNormalizerMapping());
        } else {
            throw new IllegalStateException("I do not know how to handle dn comparisons with objects of class: " + (obj == null ? null : obj.getClass()));
        }
        return dn;
    }
}

