/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.naming.NamingException;
import org.apache.directory.server.schema.bootstrap.Schema;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SchemaLoader;
import org.apache.directory.server.schema.registries.SchemaLoaderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaLoader
implements SchemaLoader {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaLoader.class);
    protected SchemaLoaderListener listener;

    @Override
    public void setListener(SchemaLoaderListener listener) {
        this.listener = listener;
    }

    protected final void notifyListenerOrRegistries(Schema schema, Registries registries) {
        if (this.listener != null) {
            this.listener.schemaLoaded(schema);
        }
        if (registries instanceof SchemaLoaderListener && registries != this.listener) {
            SchemaLoaderListener listener = (SchemaLoaderListener)((Object)registries);
            listener.schemaLoaded(schema);
        }
    }

    protected final void loadDepsFirst(Schema rootAncestor, Stack<String> beenthere, Map<String, Schema> notLoaded, Schema schema, Registries registries, Properties props) throws NamingException {
        if (registries.getLoadedSchemas().containsKey(schema.getSchemaName())) {
            log.warn("{} schema has already been loaded" + schema.getSchemaName());
            return;
        }
        beenthere.push(schema.getSchemaName());
        String[] deps = schema.getDependencies();
        if (deps == null || deps.length == 0) {
            if (rootAncestor == schema) {
                this.load(schema, registries, false);
            } else {
                this.load(schema, registries, true);
            }
            notLoaded.remove(schema.getSchemaName());
            beenthere.pop();
            return;
        }
        for (int ii = 0; ii < deps.length; ++ii) {
            if (!notLoaded.containsKey(deps[ii])) continue;
            Schema dep = notLoaded.get(deps[ii]);
            if (dep == null) {
                dep = this.getSchema(deps[ii], props);
            }
            if (beenthere.contains(dep.getSchemaName())) {
                beenthere.push(dep.getSchemaName());
                throw new NamingException("schema dependency cycle detected: " + beenthere);
            }
            this.loadDepsFirst(rootAncestor, beenthere, notLoaded, dep, registries, props);
        }
        if (rootAncestor == schema) {
            this.load(schema, registries, false);
        } else {
            this.load(schema, registries, true);
        }
        notLoaded.remove(schema.getSchemaName());
        beenthere.pop();
    }
}

