/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.SPARQLResult;
import com.hp.hpl.jena.sparql.util.LabelToNodeMap;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.openjena.atlas.json.JSON;
import org.openjena.atlas.json.JsonArray;
import org.openjena.atlas.json.JsonException;
import org.openjena.atlas.json.JsonObject;
import org.openjena.atlas.json.JsonValue;

public class JSONInput
extends SPARQLResult {
    public JSONInput(InputStream in) {
        this(in, null);
    }

    public JSONInput(InputStream in, Model model) {
        JsonObject obj;
        JSONResultSet r;
        if (model == null) {
            model = GraphFactory.makeJenaDefaultModel();
        }
        if ((r = new JSONResultSet(obj = JSONInput.toJSON(in), model)).isResultSet()) {
            this.set(r);
        } else {
            this.set(r.askResult);
        }
    }

    public static ResultSet fromJSON(InputStream in) {
        return JSONInput.fromJSON(in, null);
    }

    public static ResultSet fromJSON(InputStream in, Model model) {
        JSONInput jin = new JSONInput(in, model);
        if (jin.isResultSet()) {
            return jin.getResultSet();
        }
        throw new ResultSetException("Not a result set");
    }

    public static boolean booleanFromXML(InputStream in) {
        JSONInput jin = new JSONInput(in, null);
        if (!jin.isResultSet()) {
            return jin.getBooleanResult();
        }
        throw new ResultSetException("Not a boolean result");
    }

    public static SPARQLResult make(InputStream in, Model model) {
        return new JSONInput(in, model);
    }

    private static JsonObject toJSON(InputStream in) {
        try {
            JsonObject json2 = JSON.parse(in);
            return json2;
        }
        catch (JsonException e2) {
            throw new ResultSetException(e2.getMessage(), e2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JSONResultSet
    implements ResultSet {
        QuerySolution current = null;
        List<String> variables = new ArrayList<String>();
        Binding binding = null;
        boolean inputGraphLabels = ARQ.isTrue(ARQ.inputGraphBNodeLabels);
        LabelToNodeMap bNodes = LabelToNodeMap.createBNodeMap();
        boolean isResultSet = false;
        boolean ordered = false;
        boolean distinct = false;
        boolean finished = false;
        Model model = null;
        int row = 0;
        boolean askResult = false;
        JsonObject json = null;

        JSONResultSet(JsonObject json2) {
            this(json2, null);
        }

        JSONResultSet(JsonObject json2, Model model) {
            this.json = json2;
            this.model = model;
            this.init();
        }

        public boolean isResultSet() {
            return this.isResultSet;
        }

        public boolean getBooleanResult() {
            if (this.isResultSet()) {
                throw new ResultSetException("Not a boolean result");
            }
            return this.askResult;
        }

        private void init() {
            this.processHead();
            if (this.json.hasKey("results")) {
                this.isResultSet = true;
                this.processResults();
            }
            if (this.json.hasKey("boolean")) {
                this.isResultSet = false;
                this.processBoolean();
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.isResultSet) {
                throw new ResultSetException("Not an XML result set");
            }
            if (this.finished) {
                return false;
            }
            if (this.binding == null) {
                this.binding = this.getOneSolution();
                ++this.row;
            }
            return this.binding != null;
        }

        @Override
        public QuerySolution next() {
            return this.nextSolution();
        }

        @Override
        public QuerySolution nextSolution() {
            return new ResultBinding(this.model, this.nextBinding());
        }

        @Override
        public Binding nextBinding() {
            if (this.finished) {
                throw new NoSuchElementException("End of JSON Results");
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException("End of JSON Results");
            }
            Binding r = this.binding;
            this.binding = null;
            return r;
        }

        @Override
        public int getRowNumber() {
            return this.row;
        }

        @Override
        public List<String> getResultVars() {
            return this.variables;
        }

        public boolean isOrdered() {
            return this.ordered;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        @Override
        public Model getResourceModel() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(JSONResultSet.class.getName());
        }

        private void processBoolean() {
            try {
                this.askResult = this.json.get("boolean").getAsBoolean().value();
            }
            catch (JsonException e2) {
                throw new ResultSetException(e2.getMessage(), e2);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void processHead() {
            try {
                if (!this.json.hasKey("head")) {
                    return;
                }
                JsonObject head = this.json.get("head").getAsObject();
                if (head.hasKey("vars")) {
                    JsonArray vars = head.get("vars").getAsArray();
                    for (int i = 0; i < vars.size(); ++i) {
                        this.variables.add(vars.get(i).getAsString().value());
                    }
                }
                if (!head.hasKey("link")) return;
            }
            catch (JsonException e2) {
                throw new ResultSetException(e2.getMessage(), e2);
            }
        }

        private void processResults() {
            try {
                JsonObject results = this.json.get("results").getAsObject();
            }
            catch (JsonException e2) {
                throw new ResultSetException(e2.getMessage(), e2);
            }
        }

        private Binding getOneSolution() {
            try {
                JsonObject jresults = this.json.get("results").getAsObject();
                JsonArray jbindings = jresults.get("bindings").getAsArray();
                if (this.row < 0 || this.row >= jbindings.size()) {
                    return null;
                }
                BindingMap binding = new BindingMap();
                JsonObject jsolution = jbindings.get(this.row).getAsObject();
                for (String varName : jsolution.keys()) {
                    JsonValue x2;
                    Node node;
                    JsonObject jbinding = jsolution.get(varName).getAsObject();
                    if (!jbinding.hasKey("type")) {
                        throw new ResultSetException("Binding is missing 'type'.");
                    }
                    String type = jbinding.get("type").getAsString().getAsString().value();
                    if (type.equals("uri")) {
                        String uri = jbinding.get("value").getAsString().value();
                        node = Node.createURI((String)uri);
                        SPARQLResult.addBinding(binding, Var.alloc(varName), node);
                    }
                    if (type.equals("bnode")) {
                        String label = jbinding.get("value").getAsString().value();
                        node = null;
                        node = this.inputGraphLabels ? Node.createAnon((AnonId)new AnonId(label)) : this.bNodes.asNode(label);
                        SPARQLResult.addBinding(binding, Var.alloc(varName), node);
                    }
                    if (!type.equals("literal") && !type.equals("typed-literal")) continue;
                    String lex = jbinding.get("value").getAsString().value();
                    String lang = null;
                    String dtype = null;
                    JsonValue x1 = jbinding.get("xml:lang");
                    if (x1 != null) {
                        lang = jbinding.get("xml:lang").getAsString().value();
                    }
                    if ((x2 = jbinding.get("datatype")) != null) {
                        dtype = jbinding.get("datatype").getAsString().value();
                    }
                    Node n = NodeFactory.createLiteralNode(lex, lang, dtype);
                    SPARQLResult.addBinding(binding, Var.alloc(varName), n);
                }
                return binding;
            }
            catch (JsonException e2) {
                throw new ResultSetException(e2.getMessage(), e2);
            }
        }
    }
}

