/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.system;

public class RiotChars {
    public static boolean isAlpha(int codepoint) {
        return Character.isLetter(codepoint);
    }

    public static boolean isAlphaNumeric(int codepoint) {
        return Character.isLetterOrDigit(codepoint);
    }

    public static boolean isA2Z(int ch) {
        return RiotChars.range(ch, 'a', 'z') || RiotChars.range(ch, 'A', 'Z');
    }

    public static boolean isA2ZN(int ch) {
        return RiotChars.range(ch, 'a', 'z') || RiotChars.range(ch, 'A', 'Z') || RiotChars.range(ch, '0', '9');
    }

    public static boolean isDigit(int ch) {
        return RiotChars.range(ch, '0', '9');
    }

    public static boolean isWhitespace(int ch) {
        return ch == 32 || ch == 9 || ch == 13 || ch == 10 || ch == 12;
    }

    public static boolean isNewlineChar(int ch) {
        return ch == 13 || ch == 10;
    }

    public static int valHexChar(int ch) {
        if (RiotChars.range(ch, '0', '9')) {
            return ch - 48;
        }
        if (RiotChars.range(ch, 'a', 'f')) {
            return ch - 97 + 10;
        }
        if (RiotChars.range(ch, 'A', 'F')) {
            return ch - 65 + 10;
        }
        return -1;
    }

    public static boolean range(int ch, char a, char b) {
        return ch >= a && ch <= b;
    }

    public static boolean charInArray(int ch, char[] chars) {
        for (char xch : chars) {
            if (ch != xch) continue;
            return true;
        }
        return false;
    }
}

