/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis;

import java.io.IOException;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.retry.ExponentialBackofDelay;
import org.nuxeo.ecm.core.redis.retry.Retry;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.util.Pool;

public class RedisFailoverExecutor
implements RedisExecutor {
    protected final int timeout;
    protected final RedisExecutor executor;

    public RedisFailoverExecutor(int timeout, RedisExecutor base) {
        this.timeout = timeout;
        this.executor = base;
    }

    @Override
    public <T> T execute(final RedisCallable<T> callable) throws IOException, JedisConnectionException {
        try {
            return new Retry().retry(new Retry.Block<T>(){

                @Override
                public T retry() throws Retry.ContinueException, Retry.FailException {
                    try {
                        return RedisFailoverExecutor.this.executor.execute(callable);
                    }
                    catch (JedisConnectionException cause) {
                        throw new Retry.ContinueException(cause);
                    }
                    catch (IOException cause) {
                        throw new Retry.FailException(cause);
                    }
                }
            }, new ExponentialBackofDelay(1, this.timeout));
        }
        catch (Retry.FailException cause) {
            throw new JedisConnectionException("Cannot reconnect to jedis ..", (Throwable)cause);
        }
    }

    @Override
    public Pool<Jedis> getPool() {
        return this.executor.getPool();
    }

    @Override
    public boolean supportPipelined() {
        return this.executor.supportPipelined();
    }
}

