/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.retry;

public class Retry {
    public <T> T retry(Block<T> block, Policy policy) throws FailException {
        FailException causes = new FailException("Cannot execute block, retry policy failed, check supressed exception for more infos");
        while (policy.allow()) {
            try {
                return block.retry();
            }
            catch (ContinueException error) {
                causes.addSuppressed(error.getCause());
            }
            catch (FailException error) {
                causes.addSuppressed(error.getCause());
                throw causes;
            }
            policy.pause();
        }
        throw causes;
    }

    public static class FailException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public FailException(String message) {
            super(message);
        }

        public FailException(Throwable cause) {
            super(cause);
        }
    }

    public static class ContinueException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ContinueException(Throwable cause) {
            super(cause);
        }
    }

    public static interface Policy {
        public boolean allow();

        public void pause();
    }

    public static interface Block<T> {
        public T retry() throws FailException, ContinueException;
    }
}

