/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.util.HashMap;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;

@Operation(id="Picture.resize", category="Conversion", label="Resize a picture", description="Use conversion servcie to resize a picture contained in a Document or a Blob")
public class PictureResize {
    private static final String HEIGHT = "height";
    private static final String WIDTH = "width";
    private static final String PICTURE_RESIZE_CONVERTER = "pictureResize";
    public static final String ID = "Picture.resize";
    @Param(name="maxWidth", required=true)
    protected int maxWidth = 0;
    @Param(name="maxHeight", required=true)
    protected int maxHeigh = 0;
    @Context
    protected ConversionService service;

    @OperationMethod
    public Blob run(DocumentModel doc) throws Exception {
        Blob pictureBlob = null;
        MultiviewPicture mvp = (MultiviewPicture)doc.getAdapter(MultiviewPicture.class);
        if (mvp != null) {
            pictureBlob = (Blob)mvp.getView(mvp.getOrigin()).getContent();
        } else {
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh != null) {
                pictureBlob = bh.getBlob();
            }
        }
        if (pictureBlob == null) {
            StringBlob blob = new StringBlob("Unable to find a picture in the Document");
            blob.setMimeType("text/plain");
            blob.setFilename(doc.getName() + ".null");
            return blob;
        }
        return this.run(pictureBlob);
    }

    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put(WIDTH, this.maxWidth);
        parameters.put(HEIGHT, this.maxHeigh);
        if (!this.service.isConverterAvailable(PICTURE_RESIZE_CONVERTER).isAvailable()) {
            return blob;
        }
        BlobHolder result = this.service.convert(PICTURE_RESIZE_CONVERTER, (BlobHolder)bh, parameters);
        if (result != null) {
            return result.getBlob();
        }
        StringBlob fakeRes = new StringBlob("Converter did not return any result");
        fakeRes.setMimeType("text/plain");
        return fakeRes;
    }
}

