/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.login;

import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.common.utils.Base64;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.webengine.jaxrs.login.AuthenticationHandler;
import org.nuxeo.runtime.api.Framework;

public class Base64AuthenticationHandler
implements AuthenticationHandler {
    protected String realmName = "Nuxeo";

    @Override
    public void init(Map<String, String> properties) {
        String name = properties.get("realmName");
        if (name == null) {
            this.realmName = name;
        }
    }

    @Override
    public LoginContext handleAuthentication(HttpServletRequest request, HttpServletResponse response) throws LoginException {
        String[] login = this.retrieveBasicLogin(request);
        if (login != null) {
            return Framework.login((String)login[0], (Object)login[1]);
        }
        return null;
    }

    protected String[] retrieveBasicLogin(HttpServletRequest httpRequest) {
        String auth = httpRequest.getHeader("authorization");
        if (auth != null && auth.toLowerCase().startsWith("basic")) {
            int idx = auth.indexOf(32);
            String b64userpassword = auth.substring(idx + 1);
            byte[] clearUp = Base64.decode((String)b64userpassword);
            String userpassword = new String(clearUp);
            String[] up = StringUtils.split((String)userpassword, (char)':', (boolean)false);
            if (up.length != 2) {
                return null;
            }
            return up;
        }
        return null;
    }

    protected void handleLoginFailure(HttpServletRequest request, HttpServletResponse response) {
        String s = "Basic realm=\"" + this.realmName + "\"";
        response.setHeader("WWW-Authenticate", s);
        response.setStatus(401);
    }
}

