/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.views;

import java.net.URI;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.UriInfo;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.rendering.api.RenderingEngine;
import org.nuxeo.ecm.platform.rendering.api.View;
import org.nuxeo.ecm.webengine.jaxrs.views.ResourceContext;
import org.osgi.framework.Bundle;

public class BundleResource {
    public static final String VIEW_ROOT = "VROOT";
    protected ResourceContext context;

    public BundleResource() {
    }

    public BundleResource(ResourceContext context) {
        this.setContext(context);
    }

    public BundleResource setContext(ResourceContext context) {
        this.context = context;
        return this;
    }

    public ResourceContext getContext() {
        return this.context;
    }

    public final Bundle getBundle() {
        return this.context.getBundle();
    }

    public final RenderingEngine getRenderingEngine() {
        return this.context.getRenderingEngine();
    }

    public final View getView(String path) {
        String basePath = this.context.getUriInfo().getBaseUri().toString();
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return this.context.getRenderingEngine().getView(path, (Object)this).arg("baseUrl", (Object)basePath).arg(VIEW_ROOT, (Object)this.context.getViewRoot());
    }

    public final HttpServletRequest getRequest() {
        return this.context.getRequest();
    }

    public CoreSession getSession() {
        return this.context.getSession();
    }

    public Principal getPrincipal() {
        return this.context.getPrincipal();
    }

    public UriInfo getUriInfo() {
        return this.context.getUriInfo();
    }

    public URI getBaseUri() {
        return this.context.getBaseUri();
    }

    public <T extends BundleResource> T getResource(Class<T> clazz) {
        try {
            BundleResource res = (BundleResource)clazz.newInstance();
            res.setContext(this.context);
            return (T)res;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, 500);
        }
    }

    @Path(value="{any}")
    public Object dispatch(@PathParam(value="any") String segment) {
        BundleResource res = this.context.getApplication().getExtension(this, segment);
        if (res != null) {
            return res;
        }
        throw new WebApplicationException(404);
    }

    public boolean accept(BundleResource target) {
        return true;
    }
}

