/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.Base64;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.server.shared.CappedInputStream;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStream;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStreamFactory;

public final class AtomEntryParser {
    private static final long MAX_STREAM_LENGTH = 0xA00000L;
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_TITLE = "title";
    private static final String TAG_OBJECT = "object";
    private static final String TAG_CONTENT = "content";
    private static final String TAG_BASE64 = "base64";
    private static final String TAG_MEDIATYPE = "mediatype";
    private static final String TAG_FILENAME = "filename";
    private static final String TAG_TYPE = "type";
    private static final String TAG_BULK_UPDATE = "bulkUpdate";
    private static final String ATTR_SRC = "src";
    private static final String ATTR_TYPE = "type";
    private boolean ignoreAtomContentSrc;
    private CappedInputStream cappedStream;
    private final ThresholdOutputStreamFactory streamFactory;
    private ObjectData object;
    private ContentStreamImpl atomContentStream;
    private ContentStreamImpl cmisContentStream;
    private TypeDefinition typeDef;
    private BulkUpdateImpl bulkUpdate;

    public AtomEntryParser(ThresholdOutputStreamFactory streamFactory) {
        this.streamFactory = streamFactory;
    }

    public AtomEntryParser(InputStream stream, ThresholdOutputStreamFactory streamFactory) throws XMLStreamException, IOException {
        this(streamFactory);
        this.parse(stream);
    }

    public void setIgnoreAtomContentSrc(boolean ignoreAtomContentSrc) {
        this.ignoreAtomContentSrc = ignoreAtomContentSrc;
    }

    public ObjectData getObject() {
        return this.object;
    }

    public Properties getProperties() {
        return this.object == null ? null : this.object.getProperties();
    }

    public String getId() {
        Properties properties = this.getProperties();
        if (properties == null) {
            return null;
        }
        Map propertiesMap = properties.getProperties();
        if (propertiesMap == null) {
            return null;
        }
        PropertyData property = (PropertyData)propertiesMap.get("cmis:objectId");
        if (property instanceof PropertyId) {
            return (String)((PropertyId)property).getFirstValue();
        }
        return null;
    }

    public Acl getAcl() {
        return this.object == null ? null : this.object.getAcl();
    }

    public List<String> getPolicyIds() {
        if (this.object == null || this.object.getPolicyIds() == null) {
            return null;
        }
        return this.object.getPolicyIds().getPolicyIds();
    }

    public ContentStream getContentStream() {
        return this.cmisContentStream == null ? this.atomContentStream : this.cmisContentStream;
    }

    public TypeDefinition getTypeDefinition() {
        return this.typeDef;
    }

    public BulkUpdateImpl getBulkUpdate() {
        return this.bulkUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream) throws XMLStreamException, IOException {
        this.object = null;
        this.atomContentStream = null;
        this.cmisContentStream = null;
        if (stream == null) {
            return;
        }
        this.cappedStream = new CappedInputStream(stream, 0xA00000L);
        XMLStreamReader parser = XMLUtils.createParser((InputStream)this.cappedStream);
        try {
            do {
                int event;
                if ((event = parser.getEventType()) != 1) continue;
                QName name = parser.getName();
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI()) && TAG_ENTRY.equals(name.getLocalPart())) {
                    this.parseEntry(parser);
                    break;
                }
                throw new CmisInvalidArgumentException("XML is not an Atom entry!");
            } while (XMLUtils.next((XMLStreamReader)parser));
        }
        finally {
            parser.close();
        }
    }

    private void parseEntry(XMLStreamReader parser) throws XMLStreamException, IOException {
        String atomTitle = null;
        XMLUtils.next((XMLStreamReader)parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
                    if (TAG_OBJECT.equals(name.getLocalPart())) {
                        this.parseObject(parser);
                        continue;
                    }
                    if ("type".equals(name.getLocalPart())) {
                        this.parseTypeDefinition(parser);
                        continue;
                    }
                    if (TAG_BULK_UPDATE.equals(name.getLocalPart())) {
                        this.parseBulkUpdate(parser);
                        continue;
                    }
                    if (TAG_CONTENT.equals(name.getLocalPart())) {
                        this.parseCmisContent(parser);
                        continue;
                    }
                    XMLUtils.skip((XMLStreamReader)parser);
                    continue;
                }
                if ("http://www.w3.org/2005/Atom".equals(name.getNamespaceURI())) {
                    if (TAG_CONTENT.equals(name.getLocalPart())) {
                        this.parseAtomContent(parser);
                        continue;
                    }
                    if (TAG_TITLE.equals(name.getLocalPart())) {
                        atomTitle = XMLUtils.readText((XMLStreamReader)parser, (int)102400);
                        continue;
                    }
                    XMLUtils.skip((XMLStreamReader)parser);
                    continue;
                }
                XMLUtils.skip((XMLStreamReader)parser);
                continue;
            }
            if (event == 2 || !XMLUtils.next((XMLStreamReader)parser)) break;
        }
        if (this.object != null && this.object.getProperties() != null && atomTitle != null && atomTitle.length() > 0) {
            PropertyStringImpl nameProperty = new PropertyStringImpl("cmis:name", atomTitle);
            ((PropertiesImpl)this.object.getProperties()).replaceProperty((PropertyData)nameProperty);
        }
    }

    private void parseObject(XMLStreamReader parser) throws XMLStreamException {
        this.object = XMLConverter.convertObject((XMLStreamReader)parser);
    }

    private void parseTypeDefinition(XMLStreamReader parser) throws XMLStreamException {
        this.typeDef = XMLConverter.convertTypeDefinition((XMLStreamReader)parser);
    }

    private void parseBulkUpdate(XMLStreamReader parser) throws XMLStreamException {
        this.bulkUpdate = XMLConverter.convertBulkUpdate((XMLStreamReader)parser);
    }

    private void parseAtomContent(XMLStreamReader parser) throws XMLStreamException, IOException {
        this.atomContentStream = new ContentStreamImpl();
        String type = "text";
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            QName attrName = parser.getAttributeName(i);
            if ("type".equals(attrName.getLocalPart())) {
                this.atomContentStream.setMimeType(parser.getAttributeValue(i));
                if (parser.getAttributeValue(i) == null) continue;
                type = parser.getAttributeValue(i).trim().toLowerCase(Locale.ENGLISH);
                continue;
            }
            if (!ATTR_SRC.equals(attrName.getLocalPart())) continue;
            if (this.ignoreAtomContentSrc) {
                this.atomContentStream = null;
                XMLUtils.skip((XMLStreamReader)parser);
                return;
            }
            throw new CmisNotSupportedException("External content not supported!");
        }
        ThresholdOutputStream ths = null;
        byte[] bytes = null;
        if (type.equals("text") || type.equals("html")) {
            ths = this.readContentBytes(parser);
        } else if (type.equals("xhtml")) {
            bytes = AtomEntryParser.copy(parser);
        } else if (type.endsWith("/xml") || type.endsWith("+xml")) {
            bytes = AtomEntryParser.copy(parser);
        } else {
            ths = type.startsWith("text/") ? this.readContentBytes(parser) : this.readBase64(parser);
        }
        if (ths != null) {
            this.atomContentStream.setStream(ths.getInputStream());
            this.atomContentStream.setLength(BigInteger.valueOf(ths.getSize()));
        }
        if (bytes != null) {
            this.atomContentStream.setStream((InputStream)new ByteArrayInputStream(bytes));
            this.atomContentStream.setLength(BigInteger.valueOf(bytes.length));
            this.cappedStream.deductBytes(bytes.length);
        }
    }

    private void parseCmisContent(XMLStreamReader parser) throws XMLStreamException, IOException {
        this.cmisContentStream = new ContentStreamImpl();
        XMLUtils.next((XMLStreamReader)parser);
        while (true) {
            int event;
            if ((event = parser.getEventType()) == 1) {
                QName name = parser.getName();
                if ("http://docs.oasis-open.org/ns/cmis/restatom/200908/".equals(name.getNamespaceURI())) {
                    if (TAG_MEDIATYPE.equals(name.getLocalPart())) {
                        this.cmisContentStream.setMimeType(XMLUtils.readText((XMLStreamReader)parser, (int)102400));
                        continue;
                    }
                    if (TAG_BASE64.equals(name.getLocalPart())) {
                        ThresholdOutputStream ths = this.readBase64(parser);
                        this.cmisContentStream.setStream(ths.getInputStream());
                        this.cmisContentStream.setLength(BigInteger.valueOf(ths.getSize()));
                        continue;
                    }
                    XMLUtils.skip((XMLStreamReader)parser);
                    continue;
                }
                if ("http://chemistry.apache.org/".equals(name.getNamespaceURI())) {
                    if (TAG_FILENAME.equals(name.getLocalPart())) {
                        this.cmisContentStream.setFileName(XMLUtils.readText((XMLStreamReader)parser, (int)102400));
                        continue;
                    }
                    XMLUtils.skip((XMLStreamReader)parser);
                    continue;
                }
                XMLUtils.skip((XMLStreamReader)parser);
                continue;
            }
            if (event == 2 || !XMLUtils.next((XMLStreamReader)parser)) break;
        }
        XMLUtils.next((XMLStreamReader)parser);
    }

    private ThresholdOutputStream readContentBytes(XMLStreamReader parser) throws XMLStreamException, IOException {
        ThresholdOutputStream bufferStream = this.streamFactory.newOutputStream();
        XMLUtils.next((XMLStreamReader)parser);
        try {
            int event;
            while ((event = parser.getEventType()) != 2) {
                if (event == 4) {
                    String s = parser.getText();
                    if (s != null) {
                        byte[] bytes = IOUtils.toUTF8Bytes((String)s);
                        bufferStream.write(bytes);
                        this.cappedStream.deductBytes(bytes.length);
                    }
                } else if (event == 1) {
                    throw new CmisInvalidArgumentException("Unexpected tag: " + parser.getName());
                }
                if (XMLUtils.next((XMLStreamReader)parser)) continue;
                break;
            }
        }
        catch (XMLStreamException xse) {
            bufferStream.destroy();
            throw xse;
        }
        catch (IOException ioe) {
            bufferStream.destroy();
            throw ioe;
        }
        XMLUtils.next((XMLStreamReader)parser);
        return bufferStream;
    }

    private ThresholdOutputStream readBase64(XMLStreamReader parser) throws XMLStreamException, IOException {
        ThresholdOutputStream bufferStream = this.streamFactory.newOutputStream();
        Base64.OutputStream b64stream = new Base64.OutputStream((OutputStream)bufferStream, 0);
        XMLUtils.next((XMLStreamReader)parser);
        try {
            int event;
            while ((event = parser.getEventType()) != 2) {
                if (event == 4) {
                    int len = parser.getTextLength();
                    if (len > 0) {
                        char[] chars = parser.getTextCharacters();
                        int offset = parser.getTextStart();
                        for (int i = 0; i < len; ++i) {
                            b64stream.write((int)chars[offset + i]);
                        }
                        this.cappedStream.deductBytes(len);
                    }
                } else if (event == 1) {
                    throw new CmisInvalidArgumentException("Unexpected tag: " + parser.getName());
                }
                if (XMLUtils.next((XMLStreamReader)parser)) continue;
                break;
            }
            b64stream.close();
        }
        catch (XMLStreamException xse) {
            bufferStream.destroy();
            throw xse;
        }
        catch (IOException ioe) {
            bufferStream.destroy();
            throw ioe;
        }
        XMLUtils.next((XMLStreamReader)parser);
        return bufferStream;
    }

    private static byte[] copy(XMLStreamReader parser) throws XMLStreamException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(32768);
        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
        writer.writeStartDocument();
        int level = 1;
        while (XMLUtils.next((XMLStreamReader)parser)) {
            int event = parser.getEventType();
            if (event == 1) {
                AtomEntryParser.copyStartElement(parser, writer);
                ++level;
                continue;
            }
            if (event == 4) {
                writer.writeCharacters(parser.getText());
                continue;
            }
            if (event == 5) {
                writer.writeComment(parser.getText());
                continue;
            }
            if (event == 12) {
                writer.writeCData(parser.getText());
                continue;
            }
            if (event != 2 || --level == 0) break;
            writer.writeEndElement();
        }
        writer.writeEndDocument();
        XMLUtils.next((XMLStreamReader)parser);
        return out.toByteArray();
    }

    private static void copyStartElement(XMLStreamReader parser, XMLStreamWriter writer) throws XMLStreamException {
        int i;
        String namespaceUri = parser.getNamespaceURI();
        String prefix = parser.getPrefix();
        String localName = parser.getLocalName();
        if (namespaceUri != null) {
            if (prefix == null || prefix.length() == 0) {
                writer.writeStartElement(localName);
            } else {
                writer.writeStartElement(prefix, localName, namespaceUri);
            }
        } else {
            writer.writeStartElement(localName);
        }
        for (i = 0; i < parser.getNamespaceCount(); ++i) {
            AtomEntryParser.addNamespace(writer, parser.getNamespacePrefix(i), parser.getNamespaceURI(i));
        }
        AtomEntryParser.addNamespaceIfMissing(writer, prefix, namespaceUri);
        for (i = 0; i < parser.getAttributeCount(); ++i) {
            String attrNamespaceUri = parser.getAttributeNamespace(i);
            String attrPrefix = parser.getAttributePrefix(i);
            String attrName = parser.getAttributeLocalName(i);
            String attrValue = parser.getAttributeValue(i);
            if (attrNamespaceUri == null || attrNamespaceUri.trim().length() == 0) {
                writer.writeAttribute(attrName, attrValue);
                continue;
            }
            if (attrPrefix == null || attrPrefix.trim().length() == 0) {
                writer.writeAttribute(attrNamespaceUri, attrName, attrValue);
                continue;
            }
            AtomEntryParser.addNamespaceIfMissing(writer, attrPrefix, attrNamespaceUri);
            writer.writeAttribute(attrPrefix, attrNamespaceUri, attrName, attrValue);
        }
    }

    private static void addNamespaceIfMissing(XMLStreamWriter writer, String prefix, String namespaceUri) throws XMLStreamException {
        Iterator<String> iter;
        if (namespaceUri == null || namespaceUri.trim().length() == 0) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        if ((iter = writer.getNamespaceContext().getPrefixes(namespaceUri)) == null) {
            return;
        }
        while (iter.hasNext()) {
            String p = iter.next();
            if (p == null || !p.equals(prefix)) continue;
            return;
        }
        AtomEntryParser.addNamespace(writer, prefix, namespaceUri);
    }

    private static void addNamespace(XMLStreamWriter writer, String prefix, String namespaceUri) throws XMLStreamException {
        if (prefix == null || prefix.trim().length() == 0) {
            writer.setDefaultNamespace(namespaceUri);
            writer.writeDefaultNamespace(namespaceUri);
        } else {
            writer.setPrefix(prefix, namespaceUri);
            writer.writeNamespace(prefix, namespaceUri);
        }
    }
}

